/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.configuration;

import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.shared.annotation.Description;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Optional;

@ConfigMapping(prefix="jqassistant.analyze.rule")
public interface Rule {
    public static final String DIRECTORY = "directory";
    public static final String DEFAULT_CONCEPT_SEVERITY = "default-concept-severity";
    public static final String DEFAULT_CONSTRAINT_SEVERITY = "default-constraint-severity";
    public static final String DEFAULT_GROUP_SEVERITY = "default-group-severity";
    public static final String REQUIRED_CONCEPTS_ARE_OPTIONAL_BY_DEFAULT = "required-concepts-are-optional-by-default";

    @Description(value="The name of the directory containing project rules.")
    public Optional<String> directory();

    @Description(value="The default severity of concepts without an explicit severity.")
    public Optional<Severity> defaultConceptSeverity();

    @Description(value="The default severity of constraints without an explicit severity.")
    public Optional<Severity> defaultConstraintSeverity();

    @Description(value="The default severity of groups without an explicit severity.")
    public Optional<Severity> defaultGroupSeverity();

    @Description(value="Specifies if a rule is executed even if one of the required concepts cannot be applied.")
    @WithDefault(value="true")
    public boolean requiredConceptsAreOptionalByDefault();
}

