/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.model;

import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class RuleSelection {
    private static final String GROUP_DEFAULT = "default";
    private Set<String> conceptIds;
    private Set<String> constraintIds;
    private Set<String> excludeConstraintIds;
    private Set<String> groupIds;

    public static RuleSelection select(RuleSet ruleSet, Optional<List<String>> groupIds, Optional<List<String>> constraintIds, Optional<List<String>> excludeConstraintIds, Optional<List<String>> conceptIds) {
        RuleSelectionBuilder builder = RuleSelection.builder();
        if (groupIds.isEmpty() && conceptIds.isEmpty() && constraintIds.isEmpty() && ruleSet.getGroupsBucket().getIds().contains(GROUP_DEFAULT)) {
            builder.groupIds(Set.of(GROUP_DEFAULT));
        } else {
            groupIds.ifPresent(groups -> builder.groupIds(new LinkedHashSet(groups)));
            constraintIds.ifPresent(constraints -> builder.constraintIds(new LinkedHashSet(constraints)));
            conceptIds.ifPresent(concepts -> builder.conceptIds(new LinkedHashSet(concepts)));
        }
        excludeConstraintIds.ifPresent(builder::excludeConstraintIds);
        return builder.build();
    }

    @Generated
    public static RuleSelectionBuilder builder() {
        return new RuleSelectionBuilder();
    }

    @Generated
    public Set<String> getConceptIds() {
        return this.conceptIds;
    }

    @Generated
    public Set<String> getConstraintIds() {
        return this.constraintIds;
    }

    @Generated
    public Set<String> getExcludeConstraintIds() {
        return this.excludeConstraintIds;
    }

    @Generated
    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    @Generated
    public String toString() {
        return "RuleSelection(conceptIds=" + String.valueOf(this.getConceptIds()) + ", constraintIds=" + String.valueOf(this.getConstraintIds()) + ", excludeConstraintIds=" + String.valueOf(this.getExcludeConstraintIds()) + ", groupIds=" + String.valueOf(this.getGroupIds()) + ")";
    }

    @Generated
    private RuleSelection(Set<String> conceptIds, Set<String> constraintIds, Set<String> excludeConstraintIds, Set<String> groupIds) {
        this.conceptIds = conceptIds;
        this.constraintIds = constraintIds;
        this.excludeConstraintIds = excludeConstraintIds;
        this.groupIds = groupIds;
    }

    @Generated
    public static class RuleSelectionBuilder {
        @Generated
        private ArrayList<String> conceptIds;
        @Generated
        private ArrayList<String> constraintIds;
        @Generated
        private ArrayList<String> excludeConstraintIds;
        @Generated
        private ArrayList<String> groupIds;

        @Generated
        RuleSelectionBuilder() {
        }

        @Generated
        public RuleSelectionBuilder conceptId(String conceptId) {
            if (this.conceptIds == null) {
                this.conceptIds = new ArrayList();
            }
            this.conceptIds.add(conceptId);
            return this;
        }

        @Generated
        public RuleSelectionBuilder conceptIds(Collection<? extends String> conceptIds) {
            if (conceptIds == null) {
                throw new NullPointerException("conceptIds cannot be null");
            }
            if (this.conceptIds == null) {
                this.conceptIds = new ArrayList();
            }
            this.conceptIds.addAll(conceptIds);
            return this;
        }

        @Generated
        public RuleSelectionBuilder clearConceptIds() {
            if (this.conceptIds != null) {
                this.conceptIds.clear();
            }
            return this;
        }

        @Generated
        public RuleSelectionBuilder constraintId(String constraintId) {
            if (this.constraintIds == null) {
                this.constraintIds = new ArrayList();
            }
            this.constraintIds.add(constraintId);
            return this;
        }

        @Generated
        public RuleSelectionBuilder constraintIds(Collection<? extends String> constraintIds) {
            if (constraintIds == null) {
                throw new NullPointerException("constraintIds cannot be null");
            }
            if (this.constraintIds == null) {
                this.constraintIds = new ArrayList();
            }
            this.constraintIds.addAll(constraintIds);
            return this;
        }

        @Generated
        public RuleSelectionBuilder clearConstraintIds() {
            if (this.constraintIds != null) {
                this.constraintIds.clear();
            }
            return this;
        }

        @Generated
        public RuleSelectionBuilder excludeConstraintId(String excludeConstraintId) {
            if (this.excludeConstraintIds == null) {
                this.excludeConstraintIds = new ArrayList();
            }
            this.excludeConstraintIds.add(excludeConstraintId);
            return this;
        }

        @Generated
        public RuleSelectionBuilder excludeConstraintIds(Collection<? extends String> excludeConstraintIds) {
            if (excludeConstraintIds == null) {
                throw new NullPointerException("excludeConstraintIds cannot be null");
            }
            if (this.excludeConstraintIds == null) {
                this.excludeConstraintIds = new ArrayList();
            }
            this.excludeConstraintIds.addAll(excludeConstraintIds);
            return this;
        }

        @Generated
        public RuleSelectionBuilder clearExcludeConstraintIds() {
            if (this.excludeConstraintIds != null) {
                this.excludeConstraintIds.clear();
            }
            return this;
        }

        @Generated
        public RuleSelectionBuilder groupId(String groupId) {
            if (this.groupIds == null) {
                this.groupIds = new ArrayList();
            }
            this.groupIds.add(groupId);
            return this;
        }

        @Generated
        public RuleSelectionBuilder groupIds(Collection<? extends String> groupIds) {
            if (groupIds == null) {
                throw new NullPointerException("groupIds cannot be null");
            }
            if (this.groupIds == null) {
                this.groupIds = new ArrayList();
            }
            this.groupIds.addAll(groupIds);
            return this;
        }

        @Generated
        public RuleSelectionBuilder clearGroupIds() {
            if (this.groupIds != null) {
                this.groupIds.clear();
            }
            return this;
        }

        @Generated
        public RuleSelection build() {
            Set<String> groupIds;
            Set<Object> excludeConstraintIds;
            Set<Object> constraintIds;
            Set<Object> conceptIds;
            switch (this.conceptIds == null ? 0 : this.conceptIds.size()) {
                case 0: {
                    conceptIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    conceptIds = Collections.singleton(this.conceptIds.get(0));
                    break;
                }
                default: {
                    conceptIds = new LinkedHashSet(this.conceptIds.size() < 0x40000000 ? 1 + this.conceptIds.size() + (this.conceptIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    conceptIds.addAll(this.conceptIds);
                    conceptIds = Collections.unmodifiableSet(conceptIds);
                }
            }
            switch (this.constraintIds == null ? 0 : this.constraintIds.size()) {
                case 0: {
                    constraintIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    constraintIds = Collections.singleton(this.constraintIds.get(0));
                    break;
                }
                default: {
                    constraintIds = new LinkedHashSet(this.constraintIds.size() < 0x40000000 ? 1 + this.constraintIds.size() + (this.constraintIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    constraintIds.addAll(this.constraintIds);
                    constraintIds = Collections.unmodifiableSet(constraintIds);
                }
            }
            switch (this.excludeConstraintIds == null ? 0 : this.excludeConstraintIds.size()) {
                case 0: {
                    excludeConstraintIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    excludeConstraintIds = Collections.singleton(this.excludeConstraintIds.get(0));
                    break;
                }
                default: {
                    excludeConstraintIds = new LinkedHashSet(this.excludeConstraintIds.size() < 0x40000000 ? 1 + this.excludeConstraintIds.size() + (this.excludeConstraintIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    excludeConstraintIds.addAll(this.excludeConstraintIds);
                    excludeConstraintIds = Collections.unmodifiableSet(excludeConstraintIds);
                }
            }
            switch (this.groupIds == null ? 0 : this.groupIds.size()) {
                case 0: {
                    groupIds = Collections.emptySet();
                    break;
                }
                case 1: {
                    groupIds = Collections.singleton(this.groupIds.get(0));
                    break;
                }
                default: {
                    groupIds = new LinkedHashSet(this.groupIds.size() < 0x40000000 ? 1 + this.groupIds.size() + (this.groupIds.size() - 3) / 3 : Integer.MAX_VALUE);
                    groupIds.addAll(this.groupIds);
                    groupIds = Collections.unmodifiableSet(groupIds);
                }
            }
            return new RuleSelection(conceptIds, constraintIds, excludeConstraintIds, groupIds);
        }

        @Generated
        public String toString() {
            return "RuleSelection.RuleSelectionBuilder(conceptIds=" + String.valueOf(this.conceptIds) + ", constraintIds=" + String.valueOf(this.constraintIds) + ", excludeConstraintIds=" + String.valueOf(this.excludeConstraintIds) + ", groupIds=" + String.valueOf(this.groupIds) + ")";
        }
    }
}

