/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.rule.api.source;

import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;

public class ClasspathRuleSource
extends RuleSource {
    public static final String RULE_RESOURCE_PATH = "META-INF/jqassistant-rules";
    private final ClassLoader classLoader;
    private final String relativePath;
    private final URL resource;

    public ClasspathRuleSource(ClassLoader classLoader, String relativePath) {
        this.classLoader = classLoader;
        this.relativePath = relativePath;
        String classpathResource = "META-INF/jqassistant-rules/" + relativePath;
        this.resource = this.getClassLoader().getResource(classpathResource);
        if (this.resource == null) {
            throw new IllegalArgumentException("Cannot find rule resource in classpath: " + classpathResource);
        }
    }

    @Override
    public String getId() {
        return this.resource.toString();
    }

    @Override
    public URL getURL() {
        return this.resource;
    }

    @Override
    public Optional<File> getDirectory() {
        return Optional.empty();
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.openStream();
    }

    private ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }
}

