/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.shared.io;

import java.io.File;
import java.util.Set;

public class FilePattern {
    private File directory;
    private Set<String> includes;
    private Set<String> excludes;

    FilePattern(File directory, Set<String> includes, Set<String> excludes) {
        this.directory = directory;
        this.includes = includes;
        this.excludes = excludes;
    }

    public static FilePatternBuilder builder() {
        return new FilePatternBuilder();
    }

    public File getDirectory() {
        return this.directory;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public String toString() {
        return "FilePattern(directory=" + this.getDirectory() + ", includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }

    public static class FilePatternBuilder {
        private File directory;
        private Set<String> includes;
        private Set<String> excludes;

        FilePatternBuilder() {
        }

        public FilePatternBuilder directory(File directory) {
            this.directory = directory;
            return this;
        }

        public FilePatternBuilder includes(Set<String> includes) {
            this.includes = includes;
            return this;
        }

        public FilePatternBuilder excludes(Set<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public FilePattern build() {
            return new FilePattern(this.directory, this.includes, this.excludes);
        }

        public String toString() {
            return "FilePattern.FilePatternBuilder(directory=" + this.directory + ", includes=" + this.includes + ", excludes=" + this.excludes + ")";
        }
    }
}

