/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.shared.xml;

import com.buschmais.jqassistant.core.shared.xml.JAXBValidationEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.validation.Schema;

public class JAXBHelper<X> {
    private Class<X> rootElementType;
    private Schema schema;
    private String targetNamespace;
    private XMLInputFactory inputFactory;
    private JAXBContext jaxbContext;

    public JAXBHelper(Class<X> rootElementType) {
        this(rootElementType, null, null);
    }

    public JAXBHelper(Class<X> rootElementType, String targetNamespace) {
        this(rootElementType, null, targetNamespace);
    }

    public JAXBHelper(Class<X> rootElementType, Schema schema, String targetNamespace) {
        this.rootElementType = rootElementType;
        this.schema = schema;
        this.targetNamespace = targetNamespace;
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{rootElementType});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context for " + rootElementType.getName(), e);
        }
    }

    public X unmarshal(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            X x = this.unmarshal(inputStream, Optional.of(url.toString()));
            return x;
        }
    }

    public X unmarshal(InputStream stream) throws IOException {
        return this.unmarshal(stream, Optional.empty());
    }

    private X unmarshal(InputStream stream, Optional<String> sourceId) throws IOException {
        try {
            NamespaceMappingStreamReader xmlStreamReader = new NamespaceMappingStreamReader(this.inputFactory.createXMLStreamReader(stream), this.targetNamespace);
            return this.unmarshal(xmlStreamReader, sourceId);
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot read XML document.", e);
        }
    }

    private X unmarshal(XMLStreamReader xmlStreamReader, Optional<String> sourceId) throws IOException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            if (this.schema != null) {
                unmarshaller.setSchema(this.schema);
                unmarshaller.setEventHandler((ValidationEventHandler)new JAXBValidationEventHandler(sourceId));
            }
            return (X)unmarshaller.unmarshal(xmlStreamReader, this.rootElementType).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot unmarshal XML document.", e);
        }
    }

    public void marshal(X value, OutputStream stream) throws IOException {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(value, stream);
        }
        catch (JAXBException e) {
            throw new IOException("Unable to marshal XML document.", e);
        }
    }

    private static class NamespaceMappingStreamReader
    extends StreamReaderDelegate {
        private String targetNamespace;

        public NamespaceMappingStreamReader(XMLStreamReader reader, String targetNamespace) {
            super(reader);
            this.targetNamespace = targetNamespace;
        }

        @Override
        public String getNamespaceURI() {
            return this.targetNamespace != null ? this.targetNamespace : super.getNamespaceURI();
        }
    }
}

