/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.shared.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlHelper.class);
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public static XMLInputFactory getXMLInputFactory() {
        return xmlInputFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean rootElementMatches(InputStreamSupplier inputStreamSupplier, Predicate<QName> rootElementPredicate) {
        try (InputStream stream = inputStreamSupplier.get();){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(stream);
            do {
                if (!reader.hasNext()) return false;
            } while (reader.next() != 1);
            boolean bl = rootElementPredicate.test(reader.getName());
            return bl;
        }
        catch (XMLStreamException e) {
            log.warn("Cannot parse XML file.");
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close XML document.", e);
        }
    }

    public static Schema getSchema(String resource) {
        Schema schema;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = schemaFactory.newSchema(XmlHelper.class.getResource(resource));
        }
        catch (SAXException e) {
            throw new IllegalStateException("Cannot read rules schema.", e);
        }
        return schema;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    public static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

