/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.shared.configuration;

import com.buschmais.jqassistant.core.shared.configuration.ConfigurationSerializer;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationMappingLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationMappingLoader.class);
    public static final String PREFIX = "jqassistant";
    public static final int ORDINAL_USERHOME = 50;
    public static final int ORDINAL_CLASSPATH = 80;
    public static final int ORDINAL_WORKING_DIRECTORY = 150;
    private static final String YAML = ".yaml";
    private static final String YML = ".yml";
    private static final List<Path> DEFAULT_CONFIG_LOCATIONS = Stream.of(".jqassistant.yml", ".jqassistant.yaml", ".jqassistant").map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toUnmodifiableList());
    private static final String CLASSPATH_RESOURCE = ".jqassistant.yml";

    public static <C> Builder<C> builder(Class<C> configurationMapping) {
        return new Builder<C>(configurationMapping, Collections.emptyList());
    }

    public static <C> Builder<C> builder(Class<C> configurationMapping, List<String> configLocations) {
        return new Builder<C>(configurationMapping, configLocations);
    }

    @Generated
    private ConfigurationMappingLoader() {
    }

    public static class Builder<C> {
        private final ConfigurationSerializer<C> configurationSerializer = new ConfigurationSerializer();
        private final Class<C> configurationMapping;
        private final List<Path> relativeConfigLocations;
        private final List<ConfigSource> configSources = new ArrayList<ConfigSource>();
        private final List<String> profiles = new ArrayList<String>();
        private final Set<String> ignoreProperties = new HashSet<String>();

        private Builder(Class<C> configurationMapping, List<String> configLocations) {
            this.configurationMapping = configurationMapping;
            if (configLocations.isEmpty()) {
                this.relativeConfigLocations = DEFAULT_CONFIG_LOCATIONS;
            } else {
                this.relativeConfigLocations = new ArrayList<Path>();
                for (String configLocation : configLocations) {
                    Path configLocationPath = Paths.get(configLocation, new String[0]);
                    if (configLocationPath.isAbsolute()) {
                        this.configSources.addAll(this.getExternalYamlConfigSources(configLocationPath, 150));
                        continue;
                    }
                    this.relativeConfigLocations.add(configLocationPath);
                }
            }
        }

        public Builder<C> withUserHome(File userHome) {
            this.configSources.addAll(this.getExternalYamlConfigSources(userHome, DEFAULT_CONFIG_LOCATIONS, 50));
            return this;
        }

        public Builder<C> withWorkingDirectory(File workingDirectory) {
            return this.withDirectory(workingDirectory, 150);
        }

        public Builder<C> withDirectory(File directory, int ordinal) {
            this.configSources.addAll(this.getExternalYamlConfigSources(directory, this.relativeConfigLocations, ordinal));
            return this;
        }

        public Builder<C> withClasspath() {
            this.configSources.addAll(this.getYamlConfigSourceFromClasspath());
            return this;
        }

        public Builder<C> withEnvVariables() {
            this.configSources.add((ConfigSource)new EnvConfigSource(){});
            return this;
        }

        public Builder<C> withProfiles(List<String> profiles) {
            this.profiles.addAll(profiles);
            return this;
        }

        public Builder<C> withIgnoreProperties(Collection<String> ignoreProperties) {
            this.ignoreProperties.addAll(ignoreProperties);
            return this;
        }

        public C load(ConfigSource ... additionalConfigSources) {
            log.debug("Loading configuration using profiles {}. ", this.profiles);
            SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(this.configSources).withSources(additionalConfigSources).withProfiles(this.profiles).withInterceptors(new ConfigSourceInterceptor[]{new ExpressionConfigSourceInterceptor()}).withMapping(this.configurationMapping).withValidateUnknown(false).build();
            if (log.isDebugEnabled()) {
                this.logConfigProblems(config);
            }
            Object configMapping = config.getConfigMapping(this.configurationMapping);
            if (log.isDebugEnabled()) {
                log.debug("Loaded configuration from {} config sources:\n{}", (Object)additionalConfigSources.length, (Object)this.configurationSerializer.toYaml(configMapping));
            }
            return (C)configMapping;
        }

        private void logConfigProblems(SmallRyeConfig interpolatedConfig) {
            Map filteredProperties = StreamSupport.stream(interpolatedConfig.getPropertyNames().spliterator(), false).filter(property -> property.startsWith(ConfigurationMappingLoader.PREFIX)).filter(property -> !this.ignoreProperties.contains(property)).filter(property -> interpolatedConfig.getRawValue(property) != null).collect(Collectors.toMap(property -> property, arg_0 -> ((SmallRyeConfig)interpolatedConfig).getRawValue(arg_0), (s1, s2) -> null, TreeMap::new));
            log.debug("jQAssistant config properties:");
            for (Map.Entry entry : filteredProperties.entrySet()) {
                log.debug("\t{}={}", entry.getKey(), entry.getValue());
            }
            try {
                new SmallRyeConfigBuilder().withMapping(this.configurationMapping).withSources(new ConfigSource[]{new PropertiesConfigSource(filteredProperties, "jQAssistant Configuration", 100)}).build();
            }
            catch (ConfigValidationException configValidationException) {
                for (int i = 0; i < configValidationException.getProblemCount(); ++i) {
                    log.debug(configValidationException.getProblem(i).getMessage());
                }
            }
        }

        private List<ConfigSource> getExternalYamlConfigSources(File directory, List<Path> configLocations, int ordinal) {
            ArrayList<ConfigSource> yamlConfigSources = new ArrayList<ConfigSource>();
            for (Path configLocation : configLocations) {
                Path path = directory.toPath().resolve(configLocation);
                yamlConfigSources.addAll(this.getExternalYamlConfigSources(path, ordinal));
            }
            return yamlConfigSources;
        }

        private List<ConfigSource> getExternalYamlConfigSources(Path configLocationPath, int ordinal) {
            File file = configLocationPath.toFile();
            if (!file.exists()) {
                return Collections.emptyList();
            }
            if (file.isDirectory()) {
                log.info("Scanning for configuration files in directory '{}'.", (Object)configLocationPath.toAbsolutePath());
                List<Path> configurationFiles = this.findYamlConfigurationFiles(configLocationPath);
                return configurationFiles.stream().map(path -> this.getYamlConfigSource((Path)path, ordinal)).collect(Collectors.toList());
            }
            return List.of(this.getYamlConfigSource(configLocationPath, ordinal));
        }

        private List<Path> findYamlConfigurationFiles(Path configurationDirectory) {
            final ArrayList<Path> configurationFiles = new ArrayList<Path>();
            try {
                Files.walkFileTree(configurationDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String fileName = file.toFile().getName();
                        if (fileName.endsWith(ConfigurationMappingLoader.YAML) || fileName.endsWith(ConfigurationMappingLoader.YML)) {
                            configurationFiles.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot list files in configuration directory " + String.valueOf(configurationDirectory), e);
            }
            return configurationFiles;
        }

        private ConfigSource getYamlConfigSource(Path path, int ordinal) {
            try {
                return this.getYamlConfigSource(path.toUri().toURL(), ordinal);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Cannot convert path '" + String.valueOf(path) + "' ot URL.");
            }
        }

        private List<ConfigSource> getYamlConfigSourceFromClasspath() {
            try {
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(ConfigurationMappingLoader.CLASSPATH_RESOURCE);
                return Collections.list(resources).stream().map(resource -> this.getYamlConfigSource((URL)resource, 80)).collect(Collectors.toUnmodifiableList());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot get classpath resources for .jqassistant.yml", e);
            }
        }

        private ConfigSource getYamlConfigSource(URL url, int ordinal) {
            log.info("Loading YAML configuration from '{}' (priority: {}).", (Object)url, (Object)ordinal);
            try {
                return new YamlConfigSource(url, ordinal);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot create YAML config source from URL " + String.valueOf(url), e);
            }
        }
    }
}

