/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.test.plugin;

import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineManager;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineRepository;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.api.configuration.Baseline;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.Concept;
import com.buschmais.jqassistant.core.rule.api.model.Constraint;
import com.buschmais.jqassistant.core.rule.api.model.Group;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.core.runtime.api.configuration.Configuration;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationBuilder;
import com.buschmais.jqassistant.core.runtime.api.configuration.ConfigurationMappingLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginClassLoader;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginConfigurationReader;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.runtime.impl.plugin.PluginRepositoryImpl;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.configuration.Scan;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.scanner.spi.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.StoreFactory;
import com.buschmais.xo.api.Query;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.SysPropConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractPluginIT {
    public static final File TEST_STORE_DIRECTORY = new File("target/jqassistant/test-store");
    protected static final String ARTIFACT_ID = "artifact";
    private static PluginRepositoryImpl pluginRepository;
    private File workingDirectory;
    private File outputDirectory;
    protected Store store;
    protected InMemoryReportPlugin reportPlugin;
    protected RuleSet ruleSet;

    @BeforeAll
    public static void initPluginRepository() {
        PluginClassLoader pluginClassLoader = new PluginClassLoader(AbstractPluginIT.class.getClassLoader());
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(pluginClassLoader);
        pluginRepository = new PluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        pluginRepository.initialize();
    }

    @AfterAll
    public static void destroyPluginRepository() {
        if (pluginRepository != null) {
            pluginRepository.destroy();
        }
    }

    @BeforeEach
    public void beforeEach() throws IOException, RuleException {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder();
        this.configure(configurationBuilder);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        this.workingDirectory = new File(".");
        this.outputDirectory = new File(this.workingDirectory, "target/jqassistant");
        this.outputDirectory.mkdirs();
        this.startStore(configuration.store());
        this.initializeRuleSet(configuration);
        this.initializeReportPlugin(configuration);
    }

    protected void configure(ConfigurationBuilder configurationBuilder) {
    }

    protected List<String> getConfigurationProfiles() {
        return Collections.emptyList();
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder("ITConfigSource", 110);
        configurationBuilder.with(Report.class, "properties", this.getReportProperties());
        return configurationBuilder;
    }

    @AfterEach
    public void stopStore() {
        if (this.store != null) {
            this.store.stop();
        }
    }

    private Configuration createConfiguration(ConfigurationBuilder configurationBuilder) {
        return ConfigurationMappingLoader.builder(Configuration.class).withClasspath().withProfiles(this.getConfigurationProfiles()).load(new ConfigSource[]{configurationBuilder.build(), new EnvConfigSource(){}, new SysPropConfigSource()});
    }

    private void initializeRuleSet(Configuration configuration) throws RuleException, IOException {
        File rulesDirectory = this.getRulesDirectory();
        LinkedList sources = new LinkedList();
        if (rulesDirectory.exists()) {
            sources.addAll(FileRuleSource.getRuleSources((File)rulesDirectory));
        }
        sources.addAll(pluginRepository.getRulePluginRepository().getRuleSources());
        Collection ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(configuration.analyze().rule());
        RuleParser ruleParser = new RuleParser(ruleParserPlugins);
        this.ruleSet = ruleParser.parse(sources);
    }

    private File getRulesDirectory() {
        return new File(this.getClassesDirectory(this.getClass()), "rules");
    }

    private void initializeReportPlugin(Configuration configuration) {
        ReportContextImpl reportContext = new ReportContextImpl(pluginRepository.getClassLoader(), this.store, this.outputDirectory);
        Map reportPlugins = pluginRepository.getAnalyzerPluginRepository().getReportPlugins(configuration.analyze().report(), (ReportContext)reportContext);
        this.reportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins));
    }

    protected Map<String, Object> getScannerProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Object> getReportProperties() {
        return Collections.emptyMap();
    }

    protected Map<String, Collection<RuleInterpreterPlugin>> getRuleInterpreterPlugins() {
        return pluginRepository.getAnalyzerPluginRepository().getRuleInterpreterPlugins(this.getRuleInterpreterProperties());
    }

    protected Map<String, Object> getRuleInterpreterProperties() {
        return Collections.emptyMap();
    }

    private void startStore(com.buschmais.jqassistant.core.store.api.configuration.Store storeConfiguration) {
        StoreFactory storeFactory = new StoreFactory(pluginRepository.getStorePluginRepository(), plugins -> Collections.emptyList());
        this.store = storeFactory.getStore(storeConfiguration, () -> TEST_STORE_DIRECTORY);
        this.store.start();
    }

    protected Scanner getScanner() {
        return this.getScanner(this.getScannerProperties());
    }

    protected Scanner getScanner(Map<String, Object> properties) {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Scan.class, "properties", properties);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        ScannerContextImpl scannerContext = new ScannerContextImpl(pluginRepository.getClassLoader(), this.store, this.workingDirectory, this.outputDirectory);
        ScannerPluginRepository scannerPluginRepository = pluginRepository.getScannerPluginRepository();
        return new ScannerImpl(configuration.scan(), (ScannerContext)scannerContext, scannerPluginRepository);
    }

    private Analyzer getAnalyzer(Map<String, String> parameters) throws RuleException {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder().with(Analyze.class, "rule-parameters", parameters);
        Configuration configuration = this.createConfiguration(configurationBuilder);
        Baseline baselineConfiguration = configuration.analyze().baseline();
        BaselineRepository baselineRepository = new BaselineRepository(baselineConfiguration, this.getRulesDirectory());
        BaselineManager baselineManager = new BaselineManager(baselineConfiguration, baselineRepository);
        return new AnalyzerImpl(configuration.analyze(), pluginRepository.getClassLoader(), this.store, this.getRuleInterpreterPlugins(), baselineManager, (ReportPlugin)this.reportPlugin);
    }

    protected File getClassesDirectory(Class<?> rootClass) {
        String path = URLDecoder.decode(rootClass.getClassLoader().getResource(".").getPath(), Charset.defaultCharset());
        File directory = new File(path);
        Assertions.assertThat((File)directory).isDirectory().describedAs("Expected %s to be a directory", new Object[]{directory.toString()});
        return directory;
    }

    protected TestResult query(String query) {
        return this.query(query, Collections.emptyMap());
    }

    protected TestResult query(String query, Map<String, Object> parameters) {
        Query.Result compositeRowObjects = this.store.executeQuery(query, parameters);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, List<Object>> columns = new HashMap<String, List<Object>>();
        for (Query.Result.CompositeRowObject rowObject : compositeRowObjects) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            List columnNames = rowObject.getColumns();
            for (String columnName : columnNames) {
                ArrayList<Object> columnValues = (ArrayList<Object>)columns.get(columnName);
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>();
                    columns.put(columnName, columnValues);
                }
                Object value = rowObject.get(columnName, Object.class);
                row.put(columnName, value);
                columnValues.add(value);
            }
            rows.add(row);
        }
        return new TestResult(rows, columns);
    }

    protected Result<Concept> applyConcept(String id) throws RuleException {
        return this.applyConcept(id, Collections.emptyMap());
    }

    protected Result<Concept> applyConcept(String id, Map<String, String> parameters) throws RuleException {
        Analyzer analyzer = this.getAnalyzer(parameters);
        RuleSelection ruleSelection = RuleSelection.builder().conceptId(id).build();
        Concept concept = (Concept)this.ruleSet.getConceptBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)concept).describedAs("The requested concept cannot be found: " + id, new Object[0])).isNotNull();
        analyzer.execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConceptResults().get(id);
    }

    protected Result<Constraint> validateConstraint(String id) throws RuleException {
        return this.validateConstraint(id, Collections.emptyMap());
    }

    protected Result<Constraint> validateConstraint(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().constraintId(id).build();
        Constraint constraint = (Constraint)this.ruleSet.getConstraintBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)constraint).describedAs("The requested constraint cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
        return (Result)this.reportPlugin.getConstraintResults().get(id);
    }

    protected void executeGroup(String id) throws RuleException {
        this.executeGroup(id, Collections.emptyMap());
    }

    protected void executeGroup(String id, Map<String, String> parameters) throws RuleException {
        RuleSelection ruleSelection = RuleSelection.builder().groupId(id).build();
        Group group = (Group)this.ruleSet.getGroupsBucket().getById(id);
        ((ObjectAssert)Assertions.assertThat((Object)group).describedAs("The request group cannot be found: " + id, new Object[0])).isNotNull();
        this.getAnalyzer(parameters).execute(this.ruleSet, ruleSelection);
    }

    protected class TestResult {
        private List<Map<String, Object>> rows;
        private Map<String, List<Object>> columns;

        public <T> List<T> getColumn(String name) {
            List<Object> column = this.columns.get(name);
            if (column == null) {
                throw new IllegalArgumentException("The result does not contain a column '" + name + "'.");
            }
            return column;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public Map<String, List<Object>> getColumns() {
            return this.columns;
        }

        @Generated
        private TestResult(List<Map<String, Object>> rows, Map<String, List<Object>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        @Generated
        public String toString() {
            return "AbstractPluginIT.TestResult(rows=" + this.getRows() + ", columns=" + this.getColumns() + ")";
        }
    }
}

