/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.configuration.api.ConfigurationBuilder;
import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.rule.api.configuration.Rule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.source.FileRuleSource;
import com.buschmais.jqassistant.core.rule.api.source.RuleSource;
import com.buschmais.jqassistant.core.rule.api.source.UrlRuleSource;
import com.buschmais.jqassistant.core.rule.impl.reader.RuleParser;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.mojo.RuleConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractRuleMojo
extends AbstractProjectMojo {
    @Parameter(property="jqassistant.rules.directories")
    private List<String> rulesDirectories;
    @Parameter(property="jqassistant.rules.url")
    private URL rulesUrl;
    @Parameter
    private RuleConfiguration rule = new RuleConfiguration();
    @Parameter(property="jqassistant.concepts")
    private List<String> concepts;
    @Parameter(property="jqassistant.constraints")
    private List<String> constraints;
    @Parameter(property="jqassistant.groups")
    private List<String> groups;

    @Override
    protected void configure(ConfigurationBuilder configurationBuilder) throws MojoExecutionException {
        super.configure(configurationBuilder);
        configurationBuilder.with(Rule.class, "default-concept-severity", (Enum)this.rule.getDefaultConceptSeverity());
        configurationBuilder.with(Rule.class, "default-constraint-severity", (Enum)this.rule.getDefaultConstraintSeverity());
        configurationBuilder.with(Rule.class, "default-group-severity", (Enum)this.rule.getDefaultGroupSeverity());
        configurationBuilder.with(Analyze.class, "concepts", this.concepts);
        configurationBuilder.with(Analyze.class, "constraints", this.constraints);
        configurationBuilder.with(Analyze.class, "groups", this.groups);
    }

    protected final RuleSet readRules(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException {
        Collection ruleParserPlugins;
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        PluginRepository pluginRepository = this.getPluginRepository(mojoExecutionContext.getConfiguration());
        if (this.rulesUrl != null) {
            this.getLog().debug((CharSequence)("Retrieving rules from URL " + this.rulesUrl.toString()));
            sources.add((RuleSource)new UrlRuleSource(this.rulesUrl));
        } else {
            this.addRuleFiles(sources, mojoExecutionContext.getRuleDirectory());
            if (this.rulesDirectories != null) {
                for (String directory : this.rulesDirectories) {
                    this.addRuleFiles(sources, mojoExecutionContext.getRuleDirectory(directory));
                }
            }
            List ruleSources = pluginRepository.getRulePluginRepository().getRuleSources();
            sources.addAll(ruleSources);
        }
        try {
            ruleParserPlugins = pluginRepository.getRulePluginRepository().getRuleParserPlugins(mojoExecutionContext.getConfiguration().analyze().rule());
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot get rules rule source reader plugins.", (Exception)((Object)e));
        }
        try {
            RuleParser ruleParser = new RuleParser(ruleParserPlugins);
            return ruleParser.parse(sources);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot read rules.", (Exception)((Object)e));
        }
    }

    private void addRuleFiles(List<RuleSource> sources, File directory) throws MojoExecutionException {
        List<RuleSource> ruleSources = this.readRulesDirectory(directory);
        for (RuleSource ruleSource : ruleSources) {
            this.getLog().debug((CharSequence)("Adding rules from file " + ruleSource));
            sources.add(ruleSource);
        }
    }

    private List<RuleSource> readRulesDirectory(File rulesDirectory) throws MojoExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new MojoExecutionException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        try {
            return FileRuleSource.getRuleSources((File)rulesDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read rule directory: " + rulesDirectory.getAbsolutePath(), (Exception)e);
        }
    }
}

