/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.analysis.spi.AnalyzerPluginRepository;
import com.buschmais.jqassistant.core.configuration.api.ConfigurationBuilder;
import com.buschmais.jqassistant.core.plugin.api.PluginRepository;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractRuleMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, configurator="custom")
public class AnalyzeMojo
extends AbstractRuleMojo {
    public static final String JQASSISTANT_REPORT_CLASSIFIER = "jqassistant-report";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeMojo.class);
    @Parameter(property="jqassistant.ruleParameters")
    private Map<String, String> ruleParameters;
    @Parameter(property="jqassistant.executeAppliedConcepts")
    private boolean executeAppliedConcepts = false;
    @Parameter(property="jqassistant.warnOnSeverity")
    private Severity.Threshold warnOnSeverity;
    @Parameter(property="jqassistant.failOnSeverity")
    private Severity.Threshold failOnSeverity;
    @Parameter(property="jqassistant.continueOnFailure")
    private boolean continueOnFailure = false;
    @Parameter(property="jqassistant.reportTypes")
    private Set<String> reportTypes;
    @Parameter(property="jqassistant.reportProperties")
    private Map<String, Object> reportProperties;
    @Parameter(property="jqassistant.attachReportArchive")
    private boolean attachReportArchive = false;
    @Parameter(property="jqassistant.report.xml")
    private File xmlReportFile;
    @Component
    private MavenProjectHelper mavenProjectHelper;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected boolean isConnectorRequired() {
        return false;
    }

    @Override
    protected void configure(ConfigurationBuilder configurationBuilder) throws MojoExecutionException {
        HashMap<String, String> properties;
        super.configure(configurationBuilder);
        configurationBuilder.with(Analyze.class, "execute-applied-concepts", this.executeAppliedConcepts);
        configurationBuilder.with(Analyze.class, "rule-parameters", this.ruleParameters);
        HashMap<String, String> hashMap = properties = this.reportProperties != null ? this.reportProperties : new HashMap<String, String>();
        if (this.xmlReportFile != null) {
            properties.put("xml.report.file", this.xmlReportFile.getAbsolutePath());
        }
        configurationBuilder.with(Report.class, "properties", properties);
        configurationBuilder.with(Report.class, "warn-on-severity", this.warnOnSeverity != null ? this.warnOnSeverity.toString() : null);
        configurationBuilder.with(Report.class, "fail-on-severity", this.failOnSeverity != null ? this.failOnSeverity.toString() : null);
        configurationBuilder.with(Report.class, "continue-on-failure", this.continueOnFailure);
        configurationBuilder.with(Report.class, "create-archive", this.attachReportArchive);
    }

    @Override
    public void aggregate(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        RuleSet ruleSet = this.readRules(mojoExecutionContext);
        Analyze analyze = configuration.analyze();
        RuleSelection ruleSelection = RuleSelection.select((RuleSet)ruleSet, (Optional)analyze.groups(), (Optional)analyze.constraints(), (Optional)analyze.concepts());
        File outputDirectory = mojoExecutionContext.getOutputDirectory();
        this.withStore(store -> this.analyze(configuration, rootModule, ruleSet, ruleSelection, store, outputDirectory), mojoExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(MavenConfiguration configuration, MavenProject rootModule, RuleSet ruleSet, RuleSelection ruleSelection, Store store, File outputDirectory) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Executing analysis for '" + rootModule.getName() + "'."));
        Report report = configuration.analyze().report();
        this.getLog().info((CharSequence)("Will warn on violations starting from severity '" + report.warnOnSeverity() + "'"));
        this.getLog().info((CharSequence)("Will fail on violations starting from severity '" + report.failOnSeverity() + "'."));
        PluginRepository pluginRepository = this.getPluginRepository(configuration);
        ReportContextImpl reportContext = new ReportContextImpl(pluginRepository.getClassLoader(), store, outputDirectory);
        AnalyzerPluginRepository analyzerPluginRepository = pluginRepository.getAnalyzerPluginRepository();
        Map reportPlugins = analyzerPluginRepository.getReportPlugins(report, (ReportContext)reportContext);
        InMemoryReportPlugin inMemoryReportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins, this.reportTypes.isEmpty() ? null : this.reportTypes));
        try {
            AnalyzerImpl analyzer = new AnalyzerImpl(configuration.analyze(), pluginRepository.getClassLoader(), store, analyzerPluginRepository.getRuleInterpreterPlugins(Collections.emptyMap()), (ReportPlugin)inMemoryReportPlugin, LOGGER);
            analyzer.execute(ruleSet, ruleSelection);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        if (report.createArchive()) {
            this.attachReportArchive(rootModule, (ReportContext)reportContext);
        }
        ReportHelper reportHelper = new ReportHelper(report, LOGGER);
        store.beginTransaction();
        try {
            reportHelper.verify(inMemoryReportPlugin, message -> {
                throw new MojoFailureException(message);
            });
        }
        finally {
            store.commitTransaction();
        }
    }

    private void attachReportArchive(MavenProject rootModule, ReportContext reportContext) throws MojoExecutionException {
        File reportArchive;
        try {
            reportArchive = reportContext.createReportArchive();
        }
        catch (ReportException e) {
            throw new MojoExecutionException("Cannot attach report artifact.", (Exception)((Object)e));
        }
        LOGGER.info("Created report archive {}.", (Object)reportArchive);
        this.mavenProjectHelper.attachArtifact(rootModule, "zip", JQASSISTANT_REPORT_CLASSIFIER, reportArchive);
        if (!this.currentProject.equals((Object)rootModule)) {
            LOGGER.info("Report archive has been attached to module '{}:{}:{}'. Use 'installAtEnd' (maven-install-plugin) or 'deployAtEnd' (maven-deploy-plugin) to ensure deployment to local or remote repositories.", new Object[]{rootModule.getGroupId(), rootModule.getArtifactId(), rootModule.getVersion()});
        }
    }
}

