/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.CompoundRuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.source.FileRuleSource;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.analysis.api.rule.source.UrlRuleSource;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import com.buschmais.jqassistant.scm.maven.StoreLifecycle;
import com.buschmais.jqassistant.scm.maven.provider.PluginRepositoryProvider;
import com.buschmais.jqassistant.scm.maven.provider.StoreFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    public static final String REPORT_XML = "jqassistant-report.xml";
    public static final String PROPERTY_STORE_LIFECYCLE = "jqassistant.store.lifecycle";
    @Parameter(property="jqassistant.store.directory")
    protected File storeDirectory;
    @Parameter(property="jqassistant.useExecutionRootAsProjectRoot")
    protected boolean useExecutionRootAsProjectRoot = false;
    @Parameter(property="jqassistant.rules.directory", defaultValue="jqassistant")
    protected String rulesDirectory;
    @Parameter(property="jqassistant.rules.directories")
    protected List<String> rulesDirectories;
    @Parameter(property="jqassistant.rules.url")
    protected URL rulesUrl;
    @Parameter(property="jqassistant.concepts")
    protected List<String> concepts;
    @Parameter(property="jqassistant.constraints")
    protected List<String> constraints;
    @Parameter(property="jqassistant.groups")
    protected List<String> groups;
    @Parameter(property="jqassistant.report.xml")
    protected File xmlReportFile;
    @Parameter(property="jqassistant.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="jqassistant.store.lifecycle")
    protected StoreLifecycle storeLifecycle = StoreLifecycle.REACTOR;
    @Parameter(property="project")
    protected MavenProject currentProject;
    @Parameter(property="reactorProjects")
    protected List<MavenProject> reactorProjects;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Inject
    protected PluginRepositoryProvider pluginRepositoryProvider;
    @Component
    private RuntimeInformation runtimeInformation;
    @Inject
    private StoreFactory storeFactory;
    private RuleSetReader ruleSetReader = new CompoundRuleSetReader();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.runtimeInformation.isMavenVersion("[3.2,)")) {
            throw new MojoExecutionException("jQAssistant requires Maven 3.2.x or above.");
        }
        MavenProject rootModule = ProjectResolver.getRootModule(this.currentProject, this.reactorProjects, this.rulesDirectory, this.useExecutionRootAsProjectRoot);
        Set<MavenProject> executedModules = this.getExecutedModules(rootModule);
        this.execute(rootModule, executedModules);
        executedModules.add(this.currentProject);
    }

    protected abstract void execute(MavenProject var1, Set<MavenProject> var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isResetStoreBeforeExecution();

    protected RuleSet readRules(MavenProject rootModule) throws MojoExecutionException {
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        if (this.rulesUrl != null) {
            this.getLog().debug((CharSequence)("Retrieving rules from URL " + this.rulesUrl.toString()));
            sources.add((RuleSource)new UrlRuleSource(this.rulesUrl));
        } else {
            this.addRuleFiles(sources, ProjectResolver.getRulesDirectory(rootModule, this.rulesDirectory));
            if (this.rulesDirectories != null) {
                for (String directory : this.rulesDirectories) {
                    this.addRuleFiles(sources, ProjectResolver.getRulesDirectory(rootModule, directory));
                }
            }
            List ruleSources = this.pluginRepositoryProvider.getRulePluginRepository().getRuleSources();
            sources.addAll(ruleSources);
        }
        RuleSetBuilder ruleSetBuilder = RuleSetBuilder.newInstance();
        try {
            this.ruleSetReader.read(sources, ruleSetBuilder);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Cannot read rules.", (Exception)((Object)e));
        }
        return ruleSetBuilder.getRuleSet();
    }

    private void addRuleFiles(List<RuleSource> sources, File directory) throws MojoExecutionException {
        List<RuleSource> ruleSources = this.readRulesDirectory(directory);
        for (RuleSource ruleSource : ruleSources) {
            this.getLog().debug((CharSequence)("Adding rules from file " + ruleSource));
            sources.add(ruleSource);
        }
    }

    private List<RuleSource> readRulesDirectory(File rulesDirectory) throws MojoExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new MojoExecutionException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        this.getLog().info((CharSequence)("Reading rules from directory " + rulesDirectory.getAbsolutePath()));
        try {
            return FileRuleSource.getRuleSources((File)rulesDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read rulesDirectory: " + rulesDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(StoreOperation storeOperation, MavenProject rootModule, Set<MavenProject> executedModules) throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
        } else {
            StoreFactory storeFactory = this.storeFactory;
            synchronized (storeFactory) {
                Store store = this.getStore(rootModule);
                if (this.isResetStoreBeforeExecution() && executedModules.isEmpty()) {
                    store.reset();
                }
                try {
                    storeOperation.run(rootModule, store);
                }
                finally {
                    this.releaseStore(rootModule, store);
                }
            }
        }
    }

    protected Set<MavenProject> getExecutedModules(MavenProject rootModule) {
        HashSet executedProjects;
        ExecutionKey key = new ExecutionKey(this.execution);
        String executedModulesContextKey = AbstractProjectMojo.class.getName() + "#executedModules";
        HashMap executedProjectsPerExecutionKey = (HashMap)rootModule.getContextValue(executedModulesContextKey);
        if (executedProjectsPerExecutionKey == null) {
            executedProjectsPerExecutionKey = new HashMap();
            rootModule.setContextValue(executedModulesContextKey, executedProjectsPerExecutionKey);
        }
        if ((executedProjects = (HashSet)executedProjectsPerExecutionKey.get(key)) == null) {
            executedProjects = new HashSet();
            executedProjectsPerExecutionKey.put(key, executedProjects);
        }
        return executedProjects;
    }

    private Store getStore(MavenProject rootModule) throws MojoExecutionException {
        Store store = null;
        switch (this.storeLifecycle) {
            case MODULE: {
                break;
            }
            case REACTOR: {
                Object existingStore = rootModule.getContextValue(Store.class.getName());
                if (existingStore == null) break;
                if (!Store.class.isAssignableFrom(existingStore.getClass())) {
                    throw new MojoExecutionException("Cannot re-use store instance from reactor. Either declare the plugin as extension or execute Maven using the property -Djqassistant.store.lifecycle=" + (Object)((Object)StoreLifecycle.MODULE) + " on the command line.");
                }
                store = (Store)existingStore;
            }
        }
        if (store == null) {
            List descriptorTypes;
            File directory = this.getStoreDirectory(rootModule);
            try {
                descriptorTypes = this.pluginRepositoryProvider.getModelPluginRepository().getDescriptorTypes();
            }
            catch (PluginRepositoryException e) {
                throw new MojoExecutionException("Cannot determine model types.", (Exception)((Object)e));
            }
            store = this.storeFactory.createStore(directory, descriptorTypes);
        }
        return store;
    }

    private void releaseStore(MavenProject rootModule, Store store) {
        switch (this.storeLifecycle) {
            case MODULE: {
                this.storeFactory.closeStore(store);
                break;
            }
            case REACTOR: {
                rootModule.setContextValue(Store.class.getName(), (Object)store);
            }
        }
    }

    private File getStoreDirectory(MavenProject rootModule) {
        File directory = this.storeDirectory != null ? this.storeDirectory : new File(rootModule.getBuild().getDirectory() + "/jqassistant/store");
        return directory;
    }

    protected static interface StoreOperation {
        public void run(MavenProject var1, Store var2) throws MojoExecutionException, MojoFailureException;
    }

    private static class ExecutionKey {
        private String goal;
        private String execution;

        private ExecutionKey(MojoExecution mojoExecution) {
            this.goal = mojoExecution.getGoal();
            this.execution = mojoExecution.getExecutionId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExecutionKey)) {
                return false;
            }
            ExecutionKey that = (ExecutionKey)o;
            return this.execution.equals(that.execution) && this.goal.equals(that.goal);
        }

        public int hashCode() {
            int result = this.goal.hashCode();
            result = 31 * result + this.execution.hashCode();
            return result;
        }
    }
}

