/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.impl.CompositeReportWriter;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.report.impl.XmlReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import com.buschmais.jqassistant.scm.maven.report.JUnitReportWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class AnalyzeMojo
extends AbstractProjectMojo {
    private Logger logger = LoggerFactory.getLogger(AnalyzeMojo.class);
    @Parameter(property="jqassistant.ruleParameters")
    protected Map<String, String> ruleParameters;
    @Parameter(property="jqassistant.failOnViolations", defaultValue="false")
    protected boolean failOnViolations;
    @Parameter(property="jqassistant.executeAppliedConcepts")
    protected boolean executeAppliedConcepts = false;
    @Parameter(property="jqassistant.severity", defaultValue="info")
    protected String severity;
    @Parameter(property="jqassistant.junitReportDirectory")
    private File junitReportDirectory;
    @Parameter(property="jqassistant.reportTypes")
    private List<ReportType> reportTypes;
    @Parameter(property="jqassistant.reportProperties")
    private Map<String, Object> reportProperties;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(MavenProject rootModule, List<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        Map reportPlugins;
        this.getLog().info((CharSequence)("Executing analysis for '" + rootModule.getName() + "'."));
        RuleSet ruleSet = this.readRules(rootModule);
        RuleSelection ruleSelection = RuleSelection.Builder.select((RuleSet)ruleSet, (Collection)this.groups, (Collection)this.constraints, (Collection)this.concepts);
        HashMap<String, JUnitReportWriter> reportWriters = new HashMap<String, JUnitReportWriter>();
        if (this.reportTypes == null || this.reportTypes.isEmpty()) {
            this.reportTypes = Collections.singletonList(ReportType.JQA);
        }
        JUnitReportWriter xmlReportWriter = null;
        block17: for (ReportType reportType : this.reportTypes) {
            switch (reportType) {
                case JQA: {
                    FileWriter xmlReportFileWriter;
                    try {
                        xmlReportFileWriter = new FileWriter(this.getXmlReportFile(rootModule));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Cannot create XML report file.", (Exception)e);
                    }
                    try {
                        xmlReportWriter = new XmlReportWriter((Writer)xmlReportFileWriter);
                        continue block17;
                    }
                    catch (AnalysisListenerException e) {
                        throw new MojoExecutionException("Cannot create XML report file writer.", (Exception)((Object)e));
                    }
                }
                case JUNIT: {
                    xmlReportWriter = this.getJunitReportWriter(rootModule);
                    continue block17;
                }
            }
            throw new MojoExecutionException("Unknown report type " + (Object)((Object)reportType));
        }
        reportWriters.put("xml", xmlReportWriter);
        Map<Object, Object> properties = this.reportProperties != null ? this.reportProperties : Collections.emptyMap();
        try {
            reportPlugins = this.pluginRepositoryProvider.getReportPluginRepository().getReportPlugins(properties);
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot get report plugins.", (Exception)((Object)e));
        }
        reportWriters.putAll(reportPlugins);
        CompositeReportWriter reportWriter = new CompositeReportWriter(reportWriters);
        InMemoryReportWriter inMemoryReportWriter = new InMemoryReportWriter((AnalysisListener)reportWriter);
        AnalyzerConfiguration configuration = new AnalyzerConfiguration();
        configuration.setExecuteAppliedConcepts(this.executeAppliedConcepts);
        AnalyzerImpl analyzer = new AnalyzerImpl(configuration, store, (AnalysisListener)inMemoryReportWriter, this.logger);
        try {
            analyzer.execute(ruleSet, ruleSelection, this.ruleParameters);
        }
        catch (AnalysisException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        ReportHelper reportHelper = new ReportHelper(this.logger);
        store.beginTransaction();
        try {
            Severity effectiveSeverity;
            try {
                effectiveSeverity = Severity.fromValue((String)this.severity);
            }
            catch (RuleException e) {
                throw new MojoExecutionException("Invalid severity '" + this.severity + "'; use one of " + Arrays.toString(Severity.names()));
            }
            int conceptViolations = reportHelper.verifyConceptResults(effectiveSeverity, inMemoryReportWriter);
            int constraintViolations = reportHelper.verifyConstraintResults(effectiveSeverity, inMemoryReportWriter);
            if (this.failOnViolations && (conceptViolations > 0 || constraintViolations > 0)) {
                throw new MojoFailureException("Violations detected: " + conceptViolations + " concepts, " + constraintViolations + " constraints");
            }
        }
        finally {
            store.commitTransaction();
        }
    }

    private JUnitReportWriter getJunitReportWriter(MavenProject baseProject) throws MojoExecutionException {
        JUnitReportWriter junitReportWriter;
        if (this.junitReportDirectory == null) {
            this.junitReportDirectory = new File(baseProject.getBuild().getDirectory() + "/surefire-reports");
        }
        this.junitReportDirectory.mkdirs();
        try {
            junitReportWriter = new JUnitReportWriter(this.junitReportDirectory);
        }
        catch (AnalysisListenerException e) {
            throw new MojoExecutionException("Cannot create XML report file writer.", (Exception)((Object)e));
        }
        return junitReportWriter;
    }

    private File getXmlReportFile(MavenProject baseProject) throws MojoExecutionException {
        File selectedXmlReportFile = ProjectResolver.getOutputFile(baseProject, this.xmlReportFile, "jqassistant-report.xml");
        selectedXmlReportFile.getParentFile().mkdirs();
        return selectedXmlReportFile;
    }

    public static enum ReportType {
        JQA,
        JUNIT;

    }
}

