/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.ProjectResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.cypher.export.SubGraphExporter;
import org.neo4j.graphdb.GraphDatabaseService;

@Mojo(name="export-database", threadSafe=true)
public class ExportDatabaseMojo
extends AbstractProjectMojo {
    private static final String EXPORT_FILE = "jqassistant.cypher";
    @Parameter(property="jqassistant.export.file")
    protected File exportFile;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected void aggregate(MavenProject rootModule, List<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        File file = ProjectResolver.getOutputFile(rootModule, this.exportFile, EXPORT_FILE);
        this.getLog().info((CharSequence)("Exporting database to '" + file.getAbsolutePath() + "'"));
        EmbeddedGraphStore graphStore = (EmbeddedGraphStore)store;
        store.beginTransaction();
        try {
            GraphDatabaseService databaseService = graphStore.getGraphDatabaseService();
            SubGraph graph = DatabaseSubGraph.from((GraphDatabaseService)databaseService);
            new SubGraphExporter(graph).export(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot export database.", (Exception)e);
        }
        finally {
            store.commitTransaction();
        }
    }
}

