/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScopePluginRepository;
import com.buschmais.jqassistant.core.scanner.api.ScannerConfiguration;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.scm.maven.AbstractModuleMojo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="scan", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class ScanMojo
extends AbstractModuleMojo {
    @Parameter(property="jqassistant.scan.includes")
    protected List<ScanInclude> scanIncludes;
    @Parameter(property="jqassistant.scan.properties")
    private Map<String, Object> scanProperties;
    @Parameter(property="jqassistant.scan.continueOnError")
    private boolean continueOnError = false;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return true;
    }

    protected Map<String, Object> getPluginProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.scanProperties != null) {
            properties.putAll(this.scanProperties);
        }
        properties.put(ScanInclude.class.getName(), this.scanIncludes);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(MavenProject mavenProject, Store store) throws MojoExecutionException, MojoFailureException {
        Map scannerPlugins;
        ScannerConfiguration configuration = new ScannerConfiguration();
        configuration.setContinueOnError(this.continueOnError);
        ScannerContextImpl scannerContext = new ScannerContextImpl(store);
        ScannerPluginRepository scannerPluginRepository = this.pluginRepositoryProvider.getScannerPluginRepository();
        try {
            scannerPlugins = scannerPluginRepository.getScannerPlugins((ScannerContext)scannerContext, this.getPluginProperties());
        }
        catch (PluginRepositoryException e) {
            throw new MojoExecutionException("Cannot determine scanner plugins.", (Exception)((Object)e));
        }
        ScopePluginRepository scopePluginRepository = this.pluginRepositoryProvider.getScopePluginRepository();
        ScannerImpl scanner = new ScannerImpl(configuration, (ScannerContext)scannerContext, scannerPlugins, scopePluginRepository.getScopes());
        store.beginTransaction();
        try {
            scanner.scan((Object)mavenProject, mavenProject.getFile().getAbsolutePath(), (Scope)MavenScope.PROJECT);
        }
        finally {
            store.commitTransaction();
        }
    }
}

