/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.neo4jserver.impl.ExtendedCommunityNeoServer;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="server", threadSafe=true)
public class ServerMojo
extends AbstractProjectMojo {
    @Parameter(property="jqassistant.server.address", defaultValue="localhost")
    protected String serverAddress;
    @Parameter(property="jqassistant.server.port")
    protected Integer serverPort;

    @Override
    protected boolean isResetStoreBeforeExecution() {
        return false;
    }

    @Override
    protected void aggregate(MavenProject rootModule, List<MavenProject> projects, Store store) throws MojoExecutionException, MojoFailureException {
        ExtendedCommunityNeoServer server = new ExtendedCommunityNeoServer((EmbeddedGraphStore)store, this.serverAddress, this.serverPort != null ? this.serverPort : 7474);
        server.start();
        this.getLog().info((CharSequence)("Running server for module " + rootModule.getGroupId() + ":" + rootModule.getArtifactId() + ":" + rootModule.getVersion()));
        this.getLog().info((CharSequence)"Press <Enter> to finish.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read from System.in.", (Exception)e);
        }
        finally {
            server.stop();
        }
    }
}

