/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven.provider;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import java.io.File;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StoreFactory
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreFactory.class);
    private Map<Store, File> stores = new IdentityHashMap<Store, File>();

    public Store createStore(File directory, List<Class<?>> types) {
        LOGGER.info("Opening store in directory '" + directory.getAbsolutePath() + "'.");
        directory.getParentFile().mkdirs();
        EmbeddedGraphStore store = new EmbeddedGraphStore(directory.getAbsolutePath());
        store.start(types);
        this.stores.put((Store)store, directory);
        return store;
    }

    public void closeStore(Store store) {
        this.close(store);
        this.stores.remove(store);
    }

    public void dispose() {
        for (Store store : this.stores.keySet()) {
            this.close(store);
        }
    }

    private void close(Store store) {
        File directory = this.stores.get(store);
        LOGGER.info("Closing store in directory '" + directory.getAbsolutePath() + "'.");
        store.stop();
    }
}

