/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven.report;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Error;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Failure;
import com.buschmais.jqassistant.plugin.junit.impl.schema.ObjectFactory;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testcase;
import com.buschmais.jqassistant.plugin.junit.impl.schema.Testsuite;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class JUnitReportWriter
implements AnalysisListener<AnalysisListenerException> {
    private File directory;
    private JAXBContext jaxbContext;
    private Group group;
    private long ruleBeginTimestamp;
    private long groupBeginTimestamp;
    private Map<Result<? extends ExecutableRule>, Long> results = new LinkedHashMap<Result<? extends ExecutableRule>, Long>();

    public JUnitReportWriter(File directory) throws AnalysisListenerException {
        this.directory = directory;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new AnalysisListenerException("Cannot create jaxb context instance.", (Throwable)e);
        }
    }

    public void begin() throws AnalysisListenerException {
    }

    public void end() throws AnalysisListenerException {
    }

    public void beginGroup(Group group) throws AnalysisListenerException {
        this.group = group;
        this.groupBeginTimestamp = System.currentTimeMillis();
    }

    public void endGroup() throws AnalysisListenerException {
        Testsuite testsuite = new Testsuite();
        int tests = 0;
        int failures = 0;
        int errors = 0;
        for (Map.Entry<Result<? extends ExecutableRule>, Long> entry : this.results.entrySet()) {
            Result<? extends ExecutableRule> result = entry.getKey();
            long time = entry.getValue();
            Testcase testcase = new Testcase();
            ExecutableRule rule = result.getRule();
            testcase.setName(rule.getId());
            testcase.setClassname(this.group.getId());
            testcase.setTime(Long.toString(time));
            List rows = result.getRows();
            if (rule instanceof Concept && rows.isEmpty()) {
                Failure failure = new Failure();
                failure.setMessage(rule.getDescription());
                failure.setContent("The concept returned an empty result.");
                testcase.getFailure().add(failure);
                ++failures;
            } else if (rule instanceof Constraint && !rows.isEmpty()) {
                Error error = new Error();
                error.setMessage(rule.getDescription());
                StringBuilder sb = new StringBuilder();
                for (Map row : rows) {
                    for (Map.Entry rowEntry : row.entrySet()) {
                        sb.append((String)rowEntry.getKey());
                        sb.append("=");
                        sb.append(rowEntry.getValue());
                    }
                }
                error.setContent(sb.toString());
                testcase.getError().add(error);
                ++errors;
            }
            ++tests;
            testsuite.getTestcase().add(testcase);
        }
        testsuite.setTests(Integer.toString(tests));
        testsuite.setFailures(Integer.toString(failures));
        testsuite.setErrors(Integer.toString(errors));
        testsuite.setName(this.group.getId());
        long groupTime = System.currentTimeMillis() - this.groupBeginTimestamp;
        testsuite.setTime(Long.toString(groupTime));
        File file = new File(this.directory, "TEST-" + this.group.getId() + ".xml");
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)testsuite, file);
        }
        catch (JAXBException e) {
            throw new AnalysisListenerException("Cannot write JUnit report.", (Throwable)e);
        }
        this.group = null;
        this.results.clear();
    }

    public void beginConcept(Concept concept) throws AnalysisListenerException {
        this.ruleBeginTimestamp = System.currentTimeMillis();
    }

    public void endConcept() throws AnalysisListenerException {
    }

    public void beginConstraint(Constraint constraint) throws AnalysisListenerException {
        this.ruleBeginTimestamp = System.currentTimeMillis();
    }

    public void endConstraint() throws AnalysisListenerException {
    }

    public void setResult(Result<? extends ExecutableRule> result) throws AnalysisListenerException {
        long ruleEndTimestamp = System.currentTimeMillis();
        long time = ruleEndTimestamp - this.ruleBeginTimestamp;
        this.results.put(result, time);
    }
}

