/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineManager;
import com.buschmais.jqassistant.core.analysis.api.baseline.BaselineRepository;
import com.buschmais.jqassistant.core.analysis.api.configuration.Analyze;
import com.buschmais.jqassistant.core.analysis.api.configuration.Baseline;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.analysis.spi.AnalyzerPluginRepository;
import com.buschmais.jqassistant.core.report.api.ReportContext;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.api.configuration.Report;
import com.buschmais.jqassistant.core.report.impl.CompositeReportPlugin;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportPlugin;
import com.buschmais.jqassistant.core.report.impl.ReportContextImpl;
import com.buschmais.jqassistant.core.rule.api.RuleHelper;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.RuleSelection;
import com.buschmais.jqassistant.core.rule.api.model.RuleSet;
import com.buschmais.jqassistant.core.runtime.api.plugin.PluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.maven.AbstractRuleMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import com.buschmais.jqassistant.scm.maven.configuration.MavenConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class AnalyzeMojo
extends AbstractRuleMojo {
    public static final String JQASSISTANT_REPORT_CLASSIFIER = "jqassistant-report";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeMojo.class);
    @Component
    private MavenProjectHelper mavenProjectHelper;

    @Override
    protected void beforeProject(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException {
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        List<MavenProject> projectModules = mojoExecutionContext.getProjects().get(rootModule);
        if (projectModules.size() > 1) {
            this.validate(mojoExecutionContext);
        }
    }

    private void validate(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException {
        RuleSet ruleSet = this.readRules(mojoExecutionContext);
        Analyze analyze = mojoExecutionContext.getConfiguration().analyze();
        RuleSelection ruleSelection = RuleSelection.select((RuleSet)ruleSet, (Optional)analyze.groups(), (Optional)analyze.constraints(), (Optional)analyze.excludeConstraints(), (Optional)analyze.concepts());
        RuleHelper ruleHelper = new RuleHelper();
        try {
            ruleHelper.getAllRules(ruleSet, ruleSelection, analyze.rule());
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Invalid rule configuration.", (Exception)((Object)e));
        }
    }

    @Override
    public void afterProject(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        this.withStore(store -> this.analyze(store, mojoExecutionContext), mojoExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(Store store, MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        MavenConfiguration configuration = mojoExecutionContext.getConfiguration();
        RuleSet ruleSet = this.readRules(mojoExecutionContext);
        Analyze analyze = configuration.analyze();
        RuleSelection ruleSelection = RuleSelection.select((RuleSet)ruleSet, (Optional)analyze.groups(), (Optional)analyze.constraints(), (Optional)analyze.excludeConstraints(), (Optional)analyze.concepts());
        File outputDirectory = mojoExecutionContext.getOutputDirectory();
        this.getLog().info((CharSequence)("Executing analysis for '" + rootModule.getName() + "'."));
        Report report = analyze.report();
        PluginRepository pluginRepository = mojoExecutionContext.getPluginRepository();
        ReportContextImpl reportContext = new ReportContextImpl(report.build(), pluginRepository.getClassLoader(), store, outputDirectory);
        AnalyzerPluginRepository analyzerPluginRepository = pluginRepository.getAnalyzerPluginRepository();
        Map reportPlugins = analyzerPluginRepository.getReportPlugins(report, (ReportContext)reportContext);
        InMemoryReportPlugin inMemoryReportPlugin = new InMemoryReportPlugin((ReportPlugin)new CompositeReportPlugin(reportPlugins));
        try {
            Baseline baselineConfiguration = analyze.baseline();
            BaselineRepository baselineRepository = new BaselineRepository(baselineConfiguration, mojoExecutionContext.getRuleDirectory());
            BaselineManager baselineManager = new BaselineManager(baselineConfiguration, baselineRepository);
            AnalyzerImpl analyzer = new AnalyzerImpl(configuration.analyze(), pluginRepository.getClassLoader(), store, analyzerPluginRepository.getRuleInterpreterPlugins(Collections.emptyMap()), baselineManager, (ReportPlugin)inMemoryReportPlugin);
            analyzer.execute(ruleSet, ruleSelection);
        }
        catch (RuleException e) {
            throw new MojoExecutionException("Analysis failed.", (Exception)((Object)e));
        }
        if (report.createArchive()) {
            this.attachReportArchive(mojoExecutionContext, (ReportContext)reportContext);
        }
        ReportHelper reportHelper = new ReportHelper(report, LOGGER);
        store.beginTransaction();
        try {
            reportHelper.verify(inMemoryReportPlugin, message -> {
                throw new MojoFailureException(message);
            });
        }
        finally {
            store.commitTransaction();
        }
    }

    private void attachReportArchive(MojoExecutionContext mojoExecutionContext, ReportContext reportContext) throws MojoExecutionException {
        File reportArchive;
        MavenProject currentModule = mojoExecutionContext.getCurrentModule();
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        try {
            reportArchive = reportContext.createReportArchive();
        }
        catch (ReportException e) {
            throw new MojoExecutionException("Cannot attach report artifact.", (Exception)((Object)e));
        }
        LOGGER.info("Created report archive {}.", (Object)reportArchive);
        this.mavenProjectHelper.attachArtifact(rootModule, "zip", JQASSISTANT_REPORT_CLASSIFIER, reportArchive);
        if (!currentModule.equals((Object)rootModule)) {
            LOGGER.info("Report archive has been attached to module '{}:{}:{}'. Use 'installAtEnd' (maven-install-plugin) or 'deployAtEnd' (maven-deploy-plugin) to ensure deployment to local or remote repositories.", new Object[]{rootModule.getGroupId(), rootModule.getArtifactId(), rootModule.getVersion()});
        }
    }
}

