/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.rule;

import com.buschmais.jqassistant.core.analysis.api.AnalyzerContext;
import com.buschmais.jqassistant.core.analysis.api.RuleInterpreterPlugin;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.rule.api.model.RuleException;
import com.buschmais.jqassistant.core.rule.api.model.Severity;
import com.buschmais.jqassistant.core.rule.impl.SourceExecutable;
import com.buschmais.jqassistant.plugin.common.api.rule.JavaRule;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YamlRuleInterpreterPlugin
implements RuleInterpreterPlugin {
    public Collection<String> getLanguages() {
        return Collections.singletonList("yaml");
    }

    public <T extends ExecutableRule<?>> boolean accepts(T executableRule) {
        return executableRule.getExecutable() instanceof SourceExecutable && String.class.equals((Object)executableRule.getExecutable().getType());
    }

    public <T extends ExecutableRule<?>> Result<T> execute(T executableRule, Map<String, Object> ruleParameters, Severity severity, AnalyzerContext context) throws RuleException {
        SourceExecutable executable = (SourceExecutable)executableRule.getExecutable();
        String source = (String)executable.getSource();
        Constructor c = new Constructor(YamlRuleSource.class, new LoaderOptions());
        c.setPropertyUtils(new PropertyUtils(){

            public Property getProperty(Class<? extends Object> type, String name) {
                return super.getProperty(type, CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name));
            }
        });
        YamlRuleSource yamlRuleSource = (YamlRuleSource)new Yaml((BaseConstructor)c).loadAs(source, YamlRuleSource.class);
        String javaRuleClass = yamlRuleSource.getJavaRule();
        if (javaRuleClass == null) {
            throw new RuleException("'java-rule-class' is required.");
        }
        JavaRule javaRule = this.getJavaRule(javaRuleClass);
        return javaRule.execute(executableRule, yamlRuleSource.getConfiguration(), ruleParameters, severity, context);
    }

    private JavaRule getJavaRule(String className) throws RuleException {
        try {
            Class<?> javaRuleClass = Class.forName(className);
            if (!JavaRule.class.isAssignableFrom(JavaRule.class)) {
                throw new RuleException("Java '" + javaRuleClass.getName() + "' does not implement interface '" + JavaRule.class.getName() + "'.");
            }
            return (JavaRule)JavaRule.class.cast(javaRuleClass.newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new RuleException("Cannot create instance of '" + className + "'.", (Throwable)e);
        }
    }

    public static class YamlRuleSource {
        private String javaRule;
        private Map<String, Object> configuration;

        @Generated
        public YamlRuleSource() {
        }

        @Generated
        public String getJavaRule() {
            return this.javaRule;
        }

        @Generated
        public Map<String, Object> getConfiguration() {
            return this.configuration;
        }

        @Generated
        public void setJavaRule(String javaRule) {
            this.javaRule = javaRule;
        }

        @Generated
        public void setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof YamlRuleSource)) {
                return false;
            }
            YamlRuleSource other = (YamlRuleSource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$javaRule = this.getJavaRule();
            String other$javaRule = other.getJavaRule();
            if (this$javaRule == null ? other$javaRule != null : !this$javaRule.equals(other$javaRule)) {
                return false;
            }
            Map<String, Object> this$configuration = this.getConfiguration();
            Map<String, Object> other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof YamlRuleSource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $javaRule = this.getJavaRule();
            result = result * 59 + ($javaRule == null ? 43 : $javaRule.hashCode());
            Map<String, Object> $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YamlRuleInterpreterPlugin.YamlRuleSource(javaRule=" + this.getJavaRule() + ", configuration=" + this.getConfiguration() + ")";
        }
    }
}

