/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.shared.map.MapBuilder;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.URIDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.xo.api.Query;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUriScannerPlugin<R>
extends AbstractScannerPlugin<URI, URIDescriptor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUriScannerPlugin.class);

    @Override
    public Class<URI> getType() {
        return URI.class;
    }

    @Override
    public Class<URIDescriptor> getDescriptorType() {
        return URIDescriptor.class;
    }

    public final URIDescriptor scan(URI uri, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        return this.getResource(uri, context).map(resource -> {
            log.debug("Resolved URI '{}' to resource '{}'.", (Object)uri, resource);
            Descriptor descriptor = scanner.scan(resource, path, scope);
            if (descriptor != null) {
                URIDescriptor uriDescriptor = (URIDescriptor)context.getStore().addDescriptorType(descriptor, URIDescriptor.class);
                uriDescriptor.setUri(uri.toString());
                return uriDescriptor;
            }
            return null;
        }).orElse(null);
    }

    protected abstract Optional<R> getResource(URI var1, ScannerContext var2) throws IOException;

    protected final Optional<R> resolve(URI uri, Supplier<R> resourceSupplier, ScannerContext context) {
        Query.Result result = context.getStore().executeQuery("MATCH (uri:URI{uri:$uri}) RETURN uri", MapBuilder.builder().entry((Object)"uri", (Object)uri.toString()).build());
        if (result.hasResult()) {
            log.debug("URI '{}' has already been scanned, skipping.", (Object)uri);
            return Optional.empty();
        }
        return Optional.ofNullable(resourceSupplier.get());
    }
}

