/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.HashMap;
import java.util.Map;

public class TypeCache {
    private Cache<String, CachedType> lruCache = Caffeine.newBuilder().maximumSize(8192L).removalListener((key, value, cause) -> {
        if (RemovalCause.SIZE.equals((Object)cause)) {
            this.softCache.put(key, value);
        }
    }).build();
    private Cache<String, CachedType> softCache = Caffeine.newBuilder().softValues().build();

    TypeCache() {
    }

    public CachedType get(String fullQualifiedName) {
        CachedType cachedType = (CachedType)this.lruCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            return cachedType;
        }
        cachedType = (CachedType)this.softCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
        }
        return cachedType;
    }

    public void put(String fullQualifiedName, CachedType cachedType) {
        this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
    }

    public static class CachedType<T extends TypeDescriptor> {
        private T typeDescriptor;
        private Map<String, MemberDescriptor> members = null;
        private Map<TypeDescriptor, Integer> dependencies = null;

        public CachedType(T typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public T getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public FieldDescriptor getField(String signature) {
            return (FieldDescriptor)this.getMembers().get(signature);
        }

        public MethodDescriptor getMethod(String signature) {
            return (MethodDescriptor)this.getMembers().get(signature);
        }

        public void addMember(String signature, MemberDescriptor member) {
            this.typeDescriptor.getDeclaredMembers().add(member);
            this.getMembers().put(signature, member);
        }

        public void addDependency(TypeDescriptor dependency) {
            Map<TypeDescriptor, Integer> dependencies = this.getDependencies();
            Integer weight = dependencies.get(dependency);
            if (weight == null) {
                weight = 0;
            }
            Integer n = weight;
            Integer n2 = weight = Integer.valueOf(weight + 1);
            this.getDependencies().put(dependency, weight);
        }

        private Map<String, MemberDescriptor> getMembers() {
            if (this.members == null) {
                this.members = new HashMap<String, MemberDescriptor>();
                for (Descriptor descriptor : this.typeDescriptor.getDeclaredMembers()) {
                    if (!(descriptor instanceof MemberDescriptor)) continue;
                    MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
                    this.members.put(memberDescriptor.getSignature(), memberDescriptor);
                }
            }
            return this.members;
        }

        public Map<TypeDescriptor, Integer> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashMap<TypeDescriptor, Integer>();
                for (TypeDependsOnDescriptor dependency : this.typeDescriptor.getDependencies()) {
                    this.dependencies.put(dependency.getDependency(), dependency.getWeight());
                }
            }
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedType)) {
                return false;
            }
            CachedType that = (CachedType)o;
            return this.typeDescriptor.equals(that.typeDescriptor);
        }

        public int hashCode() {
            return this.typeDescriptor.hashCode();
        }
    }
}

