/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VariableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.BoundDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationDefaultVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.AbstractBoundVisitor;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodVisitor
extends org.objectweb.asm.MethodVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisitorHelper.class);
    private static final String JAVA_LANG_SYNTHETIC = "java.lang.Synthetic";
    private static final String THIS = "this";
    private TypeCache.CachedType containingType;
    private MethodDescriptor methodDescriptor;
    private VisitorHelper visitorHelper;
    private int syntheticParameters = 0;
    private int cyclomaticComplexity = 1;
    private Integer lineNumber = null;
    private Integer firstLineNumber = null;
    private Integer lastLineNumber = null;
    private Set<Integer> effectiveLines = new HashSet<Integer>();

    protected MethodVisitor(TypeCache.CachedType containingType, MethodDescriptor methodDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.containingType = containingType;
        this.methodDescriptor = methodDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        String annotationType = SignatureHelper.getType(desc);
        if (JAVA_LANG_SYNTHETIC.equals(annotationType)) {
            this.syntheticParameters = Math.max(this.syntheticParameters, parameter + 1);
            return null;
        }
        ParameterDescriptor parameterDescriptor = this.visitorHelper.getParameterDescriptor(this.methodDescriptor, parameter - this.syntheticParameters);
        if (parameterDescriptor == null) {
            LOGGER.warn("Cannot find parameter with index " + (parameter - this.syntheticParameters) + " in method signature " + this.containingType.getTypeDescriptor().getFullQualifiedName() + "#" + this.methodDescriptor.getSignature());
            return null;
        }
        return this.visitorHelper.addAnnotation(this.containingType, parameterDescriptor, SignatureHelper.getType(desc));
    }

    public void visitTypeInsn(int opcode, String type) {
        this.visitorHelper.resolveType(SignatureHelper.getObjectType(type), this.containingType);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        String fieldSignature = SignatureHelper.getFieldSignature(name, desc);
        TypeCache.CachedType targetType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(owner), this.containingType);
        FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(targetType, fieldSignature);
        switch (opcode) {
            case 178: 
            case 180: {
                this.visitorHelper.addReads(this.methodDescriptor, this.lineNumber, fieldDescriptor);
                break;
            }
            case 179: 
            case 181: {
                this.visitorHelper.addWrites(this.methodDescriptor, this.lineNumber, fieldDescriptor);
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String methodSignature = SignatureHelper.getMethodSignature(name, desc);
        TypeCache.CachedType targetType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(owner), this.containingType);
        MethodDescriptor invokedMethodDescriptor = this.visitorHelper.getMethodDescriptor(targetType, methodSignature);
        this.visitorHelper.addInvokes(this.methodDescriptor, this.lineNumber, invokedMethodDescriptor);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.visitorHelper.resolveType(SignatureHelper.getType((Type)cst), this.containingType);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.containingType);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.visitorHelper.getClassModelConfiguration().isMethodDeclaresVariable() && !THIS.equals(name)) {
            final VariableDescriptor variableDescriptor = this.visitorHelper.getVariableDescriptor(name, SignatureHelper.getFieldSignature(name, desc));
            if (signature == null) {
                Object type = this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.containingType).getTypeDescriptor();
                variableDescriptor.setType((TypeDescriptor)type);
            } else {
                new SignatureReader(signature).accept((SignatureVisitor)new AbstractBoundVisitor(this.visitorHelper, this.containingType){

                    @Override
                    protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                        variableDescriptor.setType(rawTypeBound);
                        variableDescriptor.setGenericType(bound);
                    }
                });
            }
            this.methodDescriptor.getVariables().add(variableDescriptor);
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationDefaultVisitor(this.containingType, this.methodDescriptor, this.visitorHelper);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            String fullQualifiedName = SignatureHelper.getObjectType(type);
            this.visitorHelper.resolveType(fullQualifiedName, this.containingType);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.visitorHelper.addAnnotation(this.containingType, this.methodDescriptor, SignatureHelper.getType(desc));
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lineNumber == null) {
            this.firstLineNumber = line;
            this.lastLineNumber = line;
        } else {
            this.firstLineNumber = Math.min(line, this.firstLineNumber);
            this.lastLineNumber = Math.max(line, this.lastLineNumber);
        }
        this.lineNumber = line;
        this.effectiveLines.add(line);
    }

    public void visitJumpInsn(int opcode, Label label) {
        ++this.cyclomaticComplexity;
    }

    public void visitEnd() {
        this.methodDescriptor.setCyclomaticComplexity(this.cyclomaticComplexity);
        if (this.firstLineNumber != null) {
            this.methodDescriptor.setFirstLineNumber(this.firstLineNumber);
        }
        if (this.lastLineNumber != null) {
            this.methodDescriptor.setLastLineNumber(this.lastLineNumber);
        }
        if (!this.effectiveLines.isEmpty()) {
            this.methodDescriptor.setEffectiveLineCount(this.effectiveLines.size());
        }
        this.visitorHelper.getTypeVariableResolver().pop();
    }
}

