/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.BoundDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.GenericArrayTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.ParameterizedTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.TypeVariableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.WildcardTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class AbstractBoundVisitor
extends SignatureVisitor {
    private static final String DEFAULT_RAW_TYPE_BOUND = "java.lang.Object";
    protected final VisitorHelper visitorHelper;
    private final TypeCache.CachedType<? extends ClassFileDescriptor> containingType;
    private BoundDescriptor current;
    private int currentTypeParameterIndex = 0;

    public AbstractBoundVisitor(VisitorHelper visitorHelper, TypeCache.CachedType<? extends ClassFileDescriptor> containingType) {
        super(589824);
        this.visitorHelper = visitorHelper;
        this.containingType = containingType;
    }

    public final void visitBaseType(char descriptor) {
        this.createBound(Type.getType((String)Character.toString(descriptor)).getClassName());
    }

    public final void visitClassType(String name) {
        this.createBound(SignatureHelper.getObjectType(name));
    }

    public final void visitInnerClassType(String name) {
        this.createBound(SignatureHelper.getObjectType(name));
    }

    private final void createBound(String rawTypeName) {
        this.current = (BoundDescriptor)this.visitorHelper.getStore().create(BoundDescriptor.class);
        Object rawType = this.visitorHelper.resolveType(rawTypeName, this.containingType).getTypeDescriptor();
        this.current.setRawType((TypeDescriptor)rawType);
        this.apply((TypeDescriptor)rawType, this.current);
    }

    public final void visitTypeVariable(String name) {
        TypeVariableDescriptor typeVariable = this.visitorHelper.getTypeVariableResolver().resolve(name, this.containingType.getTypeDescriptor());
        this.apply(typeVariable);
    }

    public final SignatureVisitor visitArrayType() {
        final GenericArrayTypeDescriptor genericArrayType = (GenericArrayTypeDescriptor)this.visitorHelper.getStore().create(GenericArrayTypeDescriptor.class);
        this.apply(genericArrayType);
        return new AbstractBoundVisitor(this.visitorHelper, this.containingType){

            @Override
            protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                genericArrayType.setComponentType(bound);
            }
        };
    }

    public final void visitTypeArgument() {
        ParameterizedTypeDescriptor parameterizedType = this.getParameterizedType();
        WildcardTypeDescriptor wildcardType = (WildcardTypeDescriptor)this.visitorHelper.getStore().create(WildcardTypeDescriptor.class);
        this.addActualArgumentType(parameterizedType, wildcardType);
    }

    public final SignatureVisitor visitTypeArgument(final char wildcard) {
        final ParameterizedTypeDescriptor parameterizedType = this.getParameterizedType();
        if (wildcard == '=') {
            return new AbstractBoundVisitor(this.visitorHelper, this.containingType){

                @Override
                protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                    AbstractBoundVisitor.this.addActualArgumentType(parameterizedType, bound);
                }
            };
        }
        final WildcardTypeDescriptor wildcardType = (WildcardTypeDescriptor)this.visitorHelper.getStore().create(WildcardTypeDescriptor.class);
        this.addActualArgumentType(parameterizedType, wildcardType);
        return new AbstractBoundVisitor(this.visitorHelper, this.containingType){

            @Override
            protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                switch (wildcard) {
                    case '+': {
                        wildcardType.getUpperBounds().add(bound);
                        break;
                    }
                    case '-': {
                        wildcardType.getLowerBounds().add(bound);
                    }
                }
            }
        };
    }

    private ParameterizedTypeDescriptor getParameterizedType() {
        return (ParameterizedTypeDescriptor)this.visitorHelper.getStore().addDescriptorType((Descriptor)this.current, ParameterizedTypeDescriptor.class);
    }

    private void addActualArgumentType(ParameterizedTypeDescriptor parameterizedType, BoundDescriptor argumentType) {
        parameterizedType.addActualTypeArgument(this.currentTypeParameterIndex++, argumentType);
    }

    private void apply(BoundDescriptor bound) {
        TypeDescriptor rawType = this.getRawTypeBound(bound);
        this.apply(rawType != null ? rawType : this.visitorHelper.resolveType(DEFAULT_RAW_TYPE_BOUND, this.containingType).getTypeDescriptor(), bound);
    }

    private TypeDescriptor getRawTypeBound(BoundDescriptor bound) {
        if (bound instanceof ParameterizedTypeDescriptor) {
            ParameterizedTypeDescriptor parameterizedType = (ParameterizedTypeDescriptor)bound;
            return parameterizedType.getRawType();
        }
        if (bound instanceof TypeVariableDescriptor) {
            TypeVariableDescriptor typeVariable = (TypeVariableDescriptor)bound;
            return this.getUniqueRawTypeBound(typeVariable.getBounds());
        }
        if (bound instanceof WildcardTypeDescriptor) {
            WildcardTypeDescriptor wildcardType = (WildcardTypeDescriptor)bound;
            List<BoundDescriptor> lowerBounds = wildcardType.getLowerBounds();
            List<BoundDescriptor> upperBounds = wildcardType.getUpperBounds();
            if (lowerBounds.size() == 1) {
                return this.getUniqueRawTypeBound(lowerBounds);
            }
            if (upperBounds.size() == 1) {
                return this.getUniqueRawTypeBound(upperBounds);
            }
        }
        return null;
    }

    private TypeDescriptor getUniqueRawTypeBound(List<BoundDescriptor> bounds) {
        return bounds.size() == 1 ? ((BoundDescriptor)bounds.stream().findFirst().get()).getRawType() : null;
    }

    protected abstract void apply(TypeDescriptor var1, BoundDescriptor var2);
}

