/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;

public abstract class AbstractTypeResolver
implements TypeResolver {
    private TypeCache typeCache = new TypeCache();

    protected AbstractTypeResolver() {
    }

    @Override
    public <T extends ClassFileDescriptor> TypeCache.CachedType<T> create(String fullQualifiedName, FileDescriptor fileDescriptor, Class<T> descriptorType, ScannerContext context) {
        ClassFileDescriptor typeDescriptor = (ClassFileDescriptor)context.getStore().addDescriptorType((Descriptor)fileDescriptor, descriptorType);
        this.setTypeProperties(typeDescriptor, fullQualifiedName);
        this.removeRequiredType(fullQualifiedName, typeDescriptor);
        this.addContainedType(fullQualifiedName, typeDescriptor);
        return this.getCachedType(fullQualifiedName, typeDescriptor);
    }

    @Override
    public TypeCache.CachedType<TypeDescriptor> resolve(String fullQualifiedName, ScannerContext context) {
        TypeCache.CachedType cachedType = this.typeCache.get(fullQualifiedName);
        if (cachedType == null) {
            TypeDescriptor typeDescriptor = this.findInArtifact(fullQualifiedName, context);
            if (typeDescriptor == null) {
                typeDescriptor = this.findInDependencies(fullQualifiedName, context);
            }
            if (typeDescriptor == null) {
                String requiredFileName = "/" + fullQualifiedName.replace(".", "/") + ".class";
                String containedFileName = this.getContainedFileName(requiredFileName);
                typeDescriptor = (TypeDescriptor)((FileResolver)context.peek(FileResolver.class)).require(requiredFileName, containedFileName, ClassFileDescriptor.class, context);
                this.setTypeProperties(typeDescriptor, fullQualifiedName);
                this.addRequiredType(fullQualifiedName, typeDescriptor);
            }
            cachedType = this.getCachedType(fullQualifiedName, typeDescriptor);
        }
        return cachedType;
    }

    protected abstract String getContainedFileName(String var1);

    private <T extends TypeDescriptor> TypeCache.CachedType<T> getCachedType(String fullQualifiedName, TypeDescriptor typeDescriptor) {
        TypeCache.CachedType<TypeDescriptor> cachedType = new TypeCache.CachedType<TypeDescriptor>(typeDescriptor);
        this.typeCache.put(fullQualifiedName, cachedType);
        return cachedType;
    }

    private <T extends TypeDescriptor> void setTypeProperties(T typeDescriptor, String fullQualifiedName) {
        int separatorIndex = fullQualifiedName.lastIndexOf(46);
        String name = separatorIndex != -1 ? fullQualifiedName.substring(separatorIndex + 1) : fullQualifiedName;
        typeDescriptor.setName(name);
        typeDescriptor.setFullQualifiedName(fullQualifiedName);
    }

    protected abstract TypeDescriptor findInArtifact(String var1, ScannerContext var2);

    protected abstract TypeDescriptor findInDependencies(String var1, ScannerContext var2);

    protected abstract void addRequiredType(String var1, TypeDescriptor var2);

    protected abstract void addContainedType(String var1, TypeDescriptor var2);

    protected abstract <T extends TypeDescriptor> void removeRequiredType(String var1, T var2);
}

