/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ModuleDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArtifactScopedTypeResolver
implements TypeResolver {
    private final String classPathDirectory;
    private JavaArtifactFileDescriptor artifact;
    private boolean hasDependencies;
    private Map<String, TypeDescriptor> artifactTypes = new HashMap<String, TypeDescriptor>();
    private final TypeCache typeCache;

    public ArtifactScopedTypeResolver(JavaArtifactFileDescriptor artifact) {
        this(artifact, null);
    }

    public ArtifactScopedTypeResolver(JavaArtifactFileDescriptor artifact, String classPathDirectory) {
        this.classPathDirectory = classPathDirectory;
        this.artifact = artifact;
        this.hasDependencies = artifact.getNumberOfDependencies() > 0L;
        this.typeCache = new TypeCache();
        this.addToCache(artifact.getContains());
        this.addToCache(artifact.getRequires());
    }

    @Override
    public final <T extends ClassFileDescriptor> TypeCache.CachedType<T> create(String fullQualifiedName, FileDescriptor fileDescriptor, Class<T> descriptorType, ScannerContext context) {
        ClassFileDescriptor typeDescriptor = (ClassFileDescriptor)context.getStore().addDescriptorType((Descriptor)fileDescriptor, descriptorType);
        this.setTypeProperties(typeDescriptor, fullQualifiedName);
        this.artifactTypes.put(fullQualifiedName, typeDescriptor);
        return this.getCachedType(fullQualifiedName, typeDescriptor);
    }

    @Override
    public final TypeCache.CachedType<TypeDescriptor> resolve(String fullQualifiedName, ScannerContext context) {
        TypeCache.CachedType cachedType = this.typeCache.get(fullQualifiedName);
        if (cachedType == null) {
            TypeDescriptor typeDescriptor = this.artifactTypes.get(fullQualifiedName);
            if (typeDescriptor == null) {
                TypeDescriptor typeDescriptor2 = typeDescriptor = this.hasDependencies ? this.artifact.resolveRequiredType(fullQualifiedName) : null;
            }
            if (typeDescriptor == null) {
                String requiredFileName = "/" + fullQualifiedName.replace(".", "/") + ".class";
                typeDescriptor = this.require(requiredFileName, ClassFileDescriptor.class, context);
                this.setTypeProperties(typeDescriptor, fullQualifiedName);
                this.artifactTypes.put(fullQualifiedName, typeDescriptor);
            }
            cachedType = this.getCachedType(fullQualifiedName, typeDescriptor);
        }
        return cachedType;
    }

    @Override
    public final <T extends FileDescriptor> T require(String requiredFileName, Class<T> requiredFileType, ScannerContext context) {
        String containedFileName = this.classPathDirectory != null ? this.classPathDirectory + requiredFileName : requiredFileName;
        return (T)((FileResolver)context.peek(FileResolver.class)).require(requiredFileName, containedFileName, requiredFileType, context);
    }

    @Override
    public final ModuleDescriptor requireModule(String moduleName, String version, ScannerContext scannerContext) {
        ModuleDescriptor requiredModule = this.artifact.findModuleInDependencies(moduleName, version);
        if (requiredModule != null) {
            return requiredModule;
        }
        return this.artifact.requireModule(moduleName, version);
    }

    private void addToCache(List<FileDescriptor> fileDescriptors) {
        for (FileDescriptor fileDescriptor : fileDescriptors) {
            if (!(fileDescriptor instanceof TypeDescriptor)) continue;
            TypeDescriptor typeDescriptor = (TypeDescriptor)fileDescriptor;
            this.artifactTypes.put(typeDescriptor.getFullQualifiedName(), typeDescriptor);
        }
    }

    private <T extends TypeDescriptor> TypeCache.CachedType<T> getCachedType(String fullQualifiedName, TypeDescriptor typeDescriptor) {
        TypeCache.CachedType<TypeDescriptor> cachedType = new TypeCache.CachedType<TypeDescriptor>(typeDescriptor);
        this.typeCache.put(fullQualifiedName, cachedType);
        return cachedType;
    }

    private <T extends TypeDescriptor> void setTypeProperties(T typeDescriptor, String fullQualifiedName) {
        int separatorIndex = fullQualifiedName.lastIndexOf(46);
        String name = separatorIndex != -1 ? fullQualifiedName.substring(separatorIndex + 1) : fullQualifiedName;
        typeDescriptor.setName(name);
        typeDescriptor.setFullQualifiedName(fullQualifiedName);
    }
}

