/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.ClassVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class ClassFileScannerPlugin
extends AbstractScannerPlugin<FileResource, ClassFileDescriptor> {
    public static final byte[] CAFEBABE = new byte[]{-54, -2, -70, -66};
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileScannerPlugin.class);

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        if (JavaScope.CLASSPATH.equals(scope) && path.endsWith(".class")) {
            try (InputStream stream = file.createStream();){
                byte[] header = new byte[CAFEBABE.length];
                int read = stream.read(header);
                boolean bl = read == CAFEBABE.length && Arrays.equals(CAFEBABE, header);
                return bl;
            }
        }
        return false;
    }

    public ClassFileDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
        ClassFileDescriptor classFileDescriptor = (ClassFileDescriptor)context.getStore().addDescriptorType((Descriptor)fileDescriptor, ClassFileDescriptor.class);
        VisitorHelper visitorHelper = new VisitorHelper(context);
        ClassVisitor visitor = new ClassVisitor(fileDescriptor, visitorHelper);
        try (InputStream inputStream = file.createStream();){
            new ClassReader(inputStream).accept((org.objectweb.asm.ClassVisitor)visitor, 0);
            classFileDescriptor.setValid(true);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Cannot scan class '" + path + "'.", (Throwable)e);
            classFileDescriptor.setValid(false);
        }
        return classFileDescriptor;
    }
}

