/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.EnumTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InterfaceTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaByteCodeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.LambdaMethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ModuleDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PrimitiveValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.RecordTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VisibilityModifier;
import com.buschmais.jqassistant.plugin.java.api.model.generics.BoundDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.FieldVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodComplexityVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodLoCVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.MethodVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.ModuleVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.delegate.DelegatingMethodVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.AbstractBoundVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.ClassSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.MethodSignatureVisitor;
import java.util.Arrays;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassVisitor
extends org.objectweb.asm.ClassVisitor {
    private final FileDescriptor fileDescriptor;
    private final VisitorHelper visitorHelper;
    private TypeCache.CachedType<? extends ClassFileDescriptor> cachedType;
    private JavaByteCodeDescriptor javaByteCodeDescriptor;
    private String sourceFileName;
    private int byteCodeVersion;

    public ClassVisitor(FileDescriptor fileDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.fileDescriptor = fileDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public ClassFileDescriptor getTypeDescriptor() {
        return this.cachedType != null ? this.cachedType.getTypeDescriptor() : null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.byteCodeVersion = version;
        Class<? extends JavaByteCodeDescriptor> javaByteCodeType = this.getJavaByteCodeType(access);
        if (ClassFileDescriptor.class.isAssignableFrom(javaByteCodeType)) {
            String fullQualifiedName = SignatureHelper.getObjectType(name);
            this.cachedType = this.visitorHelper.createType(fullQualifiedName, this.fileDescriptor, javaByteCodeType);
            this.visitorHelper.getTypeVariableResolver().push();
            ClassFileDescriptor classFileDescriptor = this.cachedType.getTypeDescriptor();
            this.javaByteCodeDescriptor = classFileDescriptor;
            if (this.visitorHelper.hasFlag(access, 1024) && !this.visitorHelper.hasFlag(access, 512)) {
                classFileDescriptor.setAbstract(Boolean.TRUE);
            }
            this.setModifiers(access, classFileDescriptor);
            if (signature == null) {
                if (superName != null) {
                    Object superClassType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(superName), this.cachedType).getTypeDescriptor();
                    classFileDescriptor.setSuperClass((TypeDescriptor)superClassType);
                }
                for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
                    Object interfaceType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(interfaces[i]), this.cachedType).getTypeDescriptor();
                    classFileDescriptor.getInterfaces().add((TypeDescriptor)interfaceType);
                }
            } else {
                new SignatureReader(signature).accept((SignatureVisitor)new ClassSignatureVisitor(this.cachedType, this.visitorHelper));
            }
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        ScannerContext scannerContext = this.visitorHelper.getScannerContext();
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)scannerContext.getStore().addDescriptorType((Descriptor)this.fileDescriptor, ModuleDescriptor.class);
        moduleDescriptor.setFullQualifiedName(name);
        moduleDescriptor.setVersion(version);
        moduleDescriptor.setOpen(this.visitorHelper.hasFlag(access, 32));
        moduleDescriptor.setSynthetic(this.visitorHelper.hasFlag(access, 4096));
        this.javaByteCodeDescriptor = moduleDescriptor;
        return new ModuleVisitor(moduleDescriptor, this.visitorHelper);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.cachedType.getTypeDescriptor().setStatic(true);
        this.cachedType.getTypeDescriptor().setFinal(true);
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final FieldDescriptor fieldDescriptor = this.visitorHelper.getFieldDescriptor(this.cachedType, SignatureHelper.getFieldSignature(name, desc));
        fieldDescriptor.setName(name);
        fieldDescriptor.setVolatile(this.visitorHelper.hasFlag(access, 64));
        fieldDescriptor.setTransient(this.visitorHelper.hasFlag(access, 128));
        this.setModifiers(access, fieldDescriptor);
        if (signature == null) {
            Object type = this.visitorHelper.resolveType(SignatureHelper.getType(desc), this.cachedType).getTypeDescriptor();
            fieldDescriptor.setType((TypeDescriptor)type);
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new AbstractBoundVisitor(this.visitorHelper, this.cachedType){

                @Override
                protected void apply(TypeDescriptor rawTypeBound, BoundDescriptor bound) {
                    fieldDescriptor.setType(rawTypeBound);
                    fieldDescriptor.setGenericType(bound);
                }
            });
        }
        if (value != null) {
            if (value instanceof Type) {
                this.visitorHelper.resolveType(SignatureHelper.getType((Type)value), this.cachedType);
            }
            PrimitiveValueDescriptor valueDescriptor = this.visitorHelper.getValueDescriptor(PrimitiveValueDescriptor.class);
            valueDescriptor.setValue(value);
            fieldDescriptor.setValue(valueDescriptor);
        }
        return new FieldVisitor(this.cachedType, fieldDescriptor, this.visitorHelper);
    }

    public org.objectweb.asm.MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String methodSignature = SignatureHelper.getMethodSignature(name, desc);
        MethodDescriptor methodDescriptor = this.visitorHelper.getMethodDescriptor(this.cachedType, methodSignature);
        if (this.isLambda(name, access)) {
            this.visitorHelper.getStore().addDescriptorType((Descriptor)methodDescriptor, LambdaMethodDescriptor.class);
        }
        this.visitorHelper.getTypeVariableResolver().push();
        methodDescriptor.setName(name);
        this.setModifiers(access, methodDescriptor);
        if (this.visitorHelper.hasFlag(access, 1024)) {
            methodDescriptor.setAbstract(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 256)) {
            methodDescriptor.setNative(Boolean.TRUE);
        }
        if (signature == null) {
            String returnType = SignatureHelper.getType(Type.getReturnType((String)desc));
            methodDescriptor.setReturns((TypeDescriptor)this.visitorHelper.resolveType(returnType, this.cachedType).getTypeDescriptor());
            Type[] types = Type.getArgumentTypes((String)desc);
            for (int i = 0; i < types.length; ++i) {
                String parameterType = SignatureHelper.getType(types[i]);
                Object typeDescriptor = this.visitorHelper.resolveType(parameterType, this.cachedType).getTypeDescriptor();
                ParameterDescriptor parameterDescriptor = this.visitorHelper.addParameterDescriptor(methodDescriptor, i);
                parameterDescriptor.setType((TypeDescriptor)typeDescriptor);
            }
        } else {
            new SignatureReader(signature).accept((SignatureVisitor)new MethodSignatureVisitor(this.cachedType, methodDescriptor, this.visitorHelper));
        }
        for (int i = 0; exceptions != null && i < exceptions.length; ++i) {
            Object exceptionType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(exceptions[i]), this.cachedType).getTypeDescriptor();
            methodDescriptor.getThrows().add((TypeDescriptor)exceptionType);
        }
        return new DelegatingMethodVisitor(Arrays.asList(new org.objectweb.asm.MethodVisitor[]{new MethodVisitor(this.cachedType, methodDescriptor, this.visitorHelper), new MethodLoCVisitor(methodDescriptor), new MethodComplexityVisitor(methodDescriptor)}));
    }

    private boolean isLambda(String name, int access) {
        if (!this.visitorHelper.hasFlag(access, 4096)) {
            return false;
        }
        return this.visitorHelper.hasFlag(access, 8) && name.startsWith("lambda$");
    }

    private void setModifiers(int access, AccessModifierDescriptor descriptor) {
        VisibilityModifier visibility = this.getVisibility(access);
        descriptor.setVisibility(visibility.getValue());
        if (this.visitorHelper.hasFlag(access, 4096)) {
            descriptor.setSynthetic(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 16)) {
            descriptor.setFinal(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 8)) {
            descriptor.setStatic(Boolean.TRUE);
        }
    }

    public void visitSource(String source, String debug) {
        this.sourceFileName = source;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String outerTypeName;
        String fullQualifiedName = this.cachedType.getTypeDescriptor().getFullQualifiedName();
        String innerTypeName = SignatureHelper.getObjectType(name);
        Object innerType = this.visitorHelper.resolveType(innerTypeName, this.cachedType).getTypeDescriptor();
        if (outerName != null && fullQualifiedName.equals(outerTypeName = SignatureHelper.getObjectType(outerName))) {
            this.cachedType.getTypeDescriptor().getDeclaredInnerClasses().add((TypeDescriptor)innerType);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        String outerTypeName = SignatureHelper.getObjectType(owner);
        TypeCache.CachedType cachedOuterType = this.visitorHelper.resolveType(outerTypeName, this.cachedType);
        ClassFileDescriptor innerType = this.cachedType.getTypeDescriptor();
        cachedOuterType.getTypeDescriptor().getDeclaredInnerClasses().add(innerType);
        if (name != null) {
            String methodSignature = SignatureHelper.getMethodSignature(name, desc);
            MethodDescriptor methodDescriptor = this.visitorHelper.getMethodDescriptor(cachedOuterType, methodSignature);
            methodDescriptor.getDeclaredInnerClasses().add(innerType);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.visitorHelper.addAnnotation(this.cachedType, this.cachedType.getTypeDescriptor(), SignatureHelper.getType(desc));
    }

    public void visitEnd() {
        this.javaByteCodeDescriptor.setByteCodeVersion(this.byteCodeVersion);
        this.javaByteCodeDescriptor.setSourceFileName(this.sourceFileName);
        if (this.cachedType != null) {
            this.visitorHelper.storeDependencies(this.cachedType);
            this.visitorHelper.getTypeVariableResolver().pop();
        }
    }

    private VisibilityModifier getVisibility(int flags) {
        if (this.visitorHelper.hasFlag(flags, 2)) {
            return VisibilityModifier.PRIVATE;
        }
        if (this.visitorHelper.hasFlag(flags, 4)) {
            return VisibilityModifier.PROTECTED;
        }
        if (this.visitorHelper.hasFlag(flags, 1)) {
            return VisibilityModifier.PUBLIC;
        }
        return VisibilityModifier.DEFAULT;
    }

    private Class<? extends JavaByteCodeDescriptor> getJavaByteCodeType(int flags) {
        if (this.visitorHelper.hasFlag(flags, 8192)) {
            return AnnotationTypeDescriptor.class;
        }
        if (this.visitorHelper.hasFlag(flags, 16384)) {
            return EnumTypeDescriptor.class;
        }
        if (this.visitorHelper.hasFlag(flags, 512)) {
            return InterfaceTypeDescriptor.class;
        }
        if (this.visitorHelper.hasFlag(flags, 65536)) {
            return RecordTypeDescriptor.class;
        }
        if (this.visitorHelper.hasFlag(flags, 32768)) {
            return ModuleDescriptor.class;
        }
        return ClassTypeDescriptor.class;
    }
}

