/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.annotation.jQASuppress;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotatedDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AnnotationValueDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ConstructorDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InvokesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaSuppressDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ParameterDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ReadsDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.VariableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.WritesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AnnotationValueVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.SuppressAnnotationVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.generics.TypeVariableResolver;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;

public class VisitorHelper {
    public static final int ASM_OPCODES = 589824;
    private static final String CONSTRUCTOR_METHOD = "void <init>";
    private final ScannerContext scannerContext;
    private final TypeVariableResolver typeVariableResolver;

    public VisitorHelper(ScannerContext scannerContext) {
        this.scannerContext = scannerContext;
        this.typeVariableResolver = new TypeVariableResolver();
    }

    public ScannerContext getScannerContext() {
        return this.scannerContext;
    }

    public Store getStore() {
        return this.scannerContext.getStore();
    }

    public TypeVariableResolver getTypeVariableResolver() {
        return this.typeVariableResolver;
    }

    public TypeCache.CachedType resolveType(String fullQualifiedName, TypeCache.CachedType<? extends ClassFileDescriptor> dependentType) {
        TypeCache.CachedType<?> cachedType = this.resolveType(fullQualifiedName);
        if (!dependentType.equals(cachedType)) {
            dependentType.addDependency((TypeDescriptor)cachedType.getTypeDescriptor());
        }
        return cachedType;
    }

    public TypeCache.CachedType<?> resolveType(String fullQualifiedName) {
        return this.getTypeResolver().resolve(fullQualifiedName, this.scannerContext);
    }

    <T extends ClassFileDescriptor> TypeCache.CachedType<T> createType(String fullQualifiedName, FileDescriptor fileDescriptor, Class<T> descriptorType) {
        return this.getTypeResolver().create(fullQualifiedName, fileDescriptor, descriptorType, this.scannerContext);
    }

    private TypeResolver getTypeResolver() {
        TypeResolver typeResolver = (TypeResolver)this.scannerContext.peek(TypeResolver.class);
        if (typeResolver == null) {
            throw new IllegalStateException("Cannot find Java type resolver.");
        }
        return typeResolver;
    }

    MethodDescriptor getMethodDescriptor(TypeCache.CachedType<?> cachedType, String signature) {
        Object methodDescriptor = cachedType.getMethod(signature);
        if (methodDescriptor == null) {
            methodDescriptor = signature.startsWith(CONSTRUCTOR_METHOD) ? (MethodDescriptor)this.scannerContext.getStore().create(ConstructorDescriptor.class) : (MethodDescriptor)this.scannerContext.getStore().create(MethodDescriptor.class);
            methodDescriptor.setSignature(signature);
            cachedType.addMember(signature, (MemberDescriptor)methodDescriptor);
        }
        return methodDescriptor;
    }

    public ParameterDescriptor addParameterDescriptor(MethodDescriptor methodDescriptor, int index) {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.scannerContext.getStore().create(ParameterDescriptor.class);
        parameterDescriptor.setIndex(index);
        methodDescriptor.getParameters().add(parameterDescriptor);
        return parameterDescriptor;
    }

    ParameterDescriptor getParameterDescriptor(MethodDescriptor methodDescriptor, int index) {
        for (ParameterDescriptor parameterDescriptor : methodDescriptor.getParameters()) {
            if (parameterDescriptor.getIndex() != index) continue;
            return parameterDescriptor;
        }
        return null;
    }

    void addInvokes(MethodDescriptor methodDescriptor, Integer lineNumber, MethodDescriptor invokedMethodDescriptor) {
        InvokesDescriptor invokesDescriptor = (InvokesDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, InvokesDescriptor.class, (Descriptor)invokedMethodDescriptor);
        invokesDescriptor.setLineNumber(lineNumber);
    }

    void addReads(MethodDescriptor methodDescriptor, Integer lineNumber, FieldDescriptor fieldDescriptor) {
        ReadsDescriptor readsDescriptor = (ReadsDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, ReadsDescriptor.class, (Descriptor)fieldDescriptor);
        readsDescriptor.setLineNumber(lineNumber);
    }

    void addWrites(MethodDescriptor methodDescriptor, Integer lineNumber, FieldDescriptor fieldDescriptor) {
        WritesDescriptor writesDescriptor = (WritesDescriptor)this.scannerContext.getStore().create((Descriptor)methodDescriptor, WritesDescriptor.class, (Descriptor)fieldDescriptor);
        writesDescriptor.setLineNumber(lineNumber);
    }

    FieldDescriptor getFieldDescriptor(TypeCache.CachedType<?> cachedType, String signature) {
        FieldDescriptor fieldDescriptor = cachedType.getField(signature);
        if (fieldDescriptor == null) {
            fieldDescriptor = (FieldDescriptor)this.scannerContext.getStore().create(FieldDescriptor.class);
            fieldDescriptor.setSignature(signature);
            cachedType.addMember(signature, fieldDescriptor);
        }
        return fieldDescriptor;
    }

    VariableDescriptor getVariableDescriptor(String name, String signature) {
        VariableDescriptor variableDescriptor = (VariableDescriptor)this.scannerContext.getStore().create(VariableDescriptor.class);
        variableDescriptor.setName(name);
        variableDescriptor.setSignature(signature);
        return variableDescriptor;
    }

    <T extends ValueDescriptor<?>> T getValueDescriptor(Class<T> valueDescriptorType) {
        return (T)((ValueDescriptor)this.scannerContext.getStore().create(valueDescriptorType));
    }

    AnnotationVisitor addAnnotation(TypeCache.CachedType containingDescriptor, AnnotatedDescriptor annotatedDescriptor, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (jQASuppress.class.getName().equals(typeName)) {
            JavaSuppressDescriptor javaSuppressDescriptor = (JavaSuppressDescriptor)this.scannerContext.getStore().addDescriptorType((Descriptor)annotatedDescriptor, JavaSuppressDescriptor.class);
            return new SuppressAnnotationVisitor(javaSuppressDescriptor);
        }
        Object type = this.resolveType(typeName, containingDescriptor).getTypeDescriptor();
        AnnotationValueDescriptor annotationDescriptor = (AnnotationValueDescriptor)this.scannerContext.getStore().create(AnnotationValueDescriptor.class);
        annotationDescriptor.setType((TypeDescriptor)type);
        annotatedDescriptor.getAnnotatedBy().add(annotationDescriptor);
        return new AnnotationValueVisitor(containingDescriptor, annotationDescriptor, this);
    }

    public void storeDependencies(TypeCache.CachedType<?> cachedType) {
        Map<TypeDescriptor, Integer> dependencies = cachedType.getDependencies();
        for (Map.Entry<TypeDescriptor, Integer> entry : dependencies.entrySet()) {
            TypeDescriptor dependency = entry.getKey();
            Integer weight = entry.getValue();
            Object dependent = cachedType.getTypeDescriptor();
            TypeDependsOnDescriptor dependsOnDescriptor = (TypeDependsOnDescriptor)this.scannerContext.getStore().create(dependent, TypeDependsOnDescriptor.class, (Descriptor)dependency);
            dependsOnDescriptor.setWeight(weight);
        }
    }

    public boolean hasFlag(int value, int flag) {
        return (value & flag) == flag;
    }
}

