/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodComplexityVisitor
extends MethodVisitor {
    private final MethodDescriptor methodDescriptor;
    private static final Set<Integer> OPCODES_IF = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 198, 199)));
    private Set<Label> whitelistLabels = new HashSet<Label>();
    private Map<Label, ExceptionHandler> exceptionHandlers = new HashMap<Label, ExceptionHandler>();
    private boolean skip = false;
    private int complexity;

    public MethodComplexityVisitor(MethodDescriptor methodDescriptor) {
        super(589824);
        this.methodDescriptor = methodDescriptor;
    }

    private void increment(int edges) {
        if (!this.skip) {
            this.complexity += edges;
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        ExceptionHandler exceptionHandler = ExceptionHandler.builder().start(start).end(end).handler(handler).type(type).build();
        this.exceptionHandlers.put(handler, exceptionHandler);
        if (!this.isSyntheticExceptionHandler(exceptionHandler)) {
            this.increment(1);
        }
    }

    public void visitLabel(Label label) {
        ExceptionHandler exceptionHandler = this.exceptionHandlers.get(label);
        if (exceptionHandler != null) {
            this.skip = this.isSyntheticExceptionHandler(exceptionHandler);
        }
        if (this.whitelistLabels.contains(label)) {
            this.skip = false;
        }
    }

    private boolean isSyntheticExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler.getType() == null || "java/lang/Throwable".equals(exceptionHandler.getType())) {
            return true;
        }
        return this.exceptionHandlers.get(exceptionHandler.getStart()) != null;
    }

    public void visitCode() {
        this.complexity = 1;
    }

    public void visitInsn(int opcode) {
        if (opcode == 191) {
            this.increment(1);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (!this.skip) {
            this.whitelistLabels.add(label);
        }
        if (OPCODES_IF.contains(opcode)) {
            this.increment(1);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.increment(labels.length + 1);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.increment(labels.length + 1);
    }

    public void visitEnd() {
        this.methodDescriptor.setCyclomaticComplexity(this.complexity);
    }

    private static class ExceptionHandler {
        private Label start;
        private Label end;
        private Label handler;
        private String type;

        @Generated
        ExceptionHandler(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }

        @Generated
        public static ExceptionHandlerBuilder builder() {
            return new ExceptionHandlerBuilder();
        }

        @Generated
        public Label getStart() {
            return this.start;
        }

        @Generated
        public Label getEnd() {
            return this.end;
        }

        @Generated
        public Label getHandler() {
            return this.handler;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "MethodComplexityVisitor.ExceptionHandler(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", handler=" + String.valueOf(this.getHandler()) + ", type=" + this.getType() + ")";
        }

        @Generated
        public static class ExceptionHandlerBuilder {
            @Generated
            private Label start;
            @Generated
            private Label end;
            @Generated
            private Label handler;
            @Generated
            private String type;

            @Generated
            ExceptionHandlerBuilder() {
            }

            @Generated
            public ExceptionHandlerBuilder start(Label start) {
                this.start = start;
                return this;
            }

            @Generated
            public ExceptionHandlerBuilder end(Label end) {
                this.end = end;
                return this;
            }

            @Generated
            public ExceptionHandlerBuilder handler(Label handler) {
                this.handler = handler;
                return this;
            }

            @Generated
            public ExceptionHandlerBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public ExceptionHandler build() {
                return new ExceptionHandler(this.start, this.end, this.handler, this.type);
            }

            @Generated
            public String toString() {
                return "MethodComplexityVisitor.ExceptionHandler.ExceptionHandlerBuilder(start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", handler=" + String.valueOf(this.handler) + ", type=" + this.type + ")";
            }
        }
    }
}

