/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.report;

import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.IndexTemplate;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.BoundDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.GenericArrayTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.ParameterizedTypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.TypeVariableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.generics.WildcardTypeDescriptor;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class JavaGenericsReportHelper {
    public String getSignature(TypeDescriptor typeDescriptor) {
        return typeDescriptor.getFullQualifiedName();
    }

    public String getSignature(FieldDescriptor fieldDescriptor) {
        BoundDescriptor genericType = fieldDescriptor.getGenericType();
        if (genericType != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getSignature(genericType));
            builder.append(' ');
            builder.append(fieldDescriptor.getName());
            return builder.toString();
        }
        return fieldDescriptor.getSignature();
    }

    public String getSignature(BoundDescriptor bound) {
        if (bound != null) {
            if (bound instanceof TypeVariableDescriptor) {
                return this.getSignature((TypeVariableDescriptor)bound);
            }
            if (bound instanceof GenericArrayTypeDescriptor) {
                return this.getSignature((GenericArrayTypeDescriptor)bound);
            }
            if (bound instanceof ParameterizedTypeDescriptor) {
                return this.getSignature((ParameterizedTypeDescriptor)bound);
            }
            if (bound instanceof WildcardTypeDescriptor) {
                return this.getSignature((WildcardTypeDescriptor)bound);
            }
            String rawTypeName = bound.getRawType().getFullQualifiedName();
            return rawTypeName.equals(Object.class.getName()) ? "" : rawTypeName;
        }
        return "";
    }

    private String getSignature(TypeVariableDescriptor typeVariableDescriptor) {
        StringBuilder builder = new StringBuilder(typeVariableDescriptor.getName());
        builder.append(this.getBounds(typeVariableDescriptor.getUpperBounds(), "extends"));
        return builder.toString();
    }

    private String getSignature(ParameterizedTypeDescriptor parameterizedTypeDescriptor) {
        StringBuilder builder = new StringBuilder(parameterizedTypeDescriptor.getRawType().getFullQualifiedName());
        builder.append('<');
        List hasActualTypeArguments = parameterizedTypeDescriptor.getActualTypeArguments().stream().collect(Collectors.toList());
        hasActualTypeArguments.sort(Comparator.comparingInt(IndexTemplate::getIndex));
        builder.append(hasActualTypeArguments.stream().map(hasActualTypeArgument -> this.getSignature(hasActualTypeArgument.getTypeArgument())).collect(Collectors.joining(",")));
        builder.append('>');
        return builder.toString();
    }

    private String getSignature(WildcardTypeDescriptor wildcardTypeDescriptor) {
        StringBuilder builder = new StringBuilder("?");
        builder.append(this.getBounds(wildcardTypeDescriptor.getUpperBounds(), "extends"));
        builder.append(this.getBounds(wildcardTypeDescriptor.getLowerBounds(), "super"));
        return builder.toString();
    }

    private String getSignature(GenericArrayTypeDescriptor genericArrayTypeDescriptor) {
        StringBuilder builder = new StringBuilder(this.getSignature(genericArrayTypeDescriptor.getComponentType()));
        builder.append("[]");
        return builder.toString();
    }

    private String getBounds(List<BoundDescriptor> bounds, String type) {
        StringBuilder builder = new StringBuilder();
        String boundSignatures = bounds.stream().map(bound -> this.getSignature((BoundDescriptor)bound)).collect(Collectors.joining(" & "));
        if (!boundSignatures.isEmpty()) {
            builder.append(' ').append(type).append(' ').append(boundSignatures);
        }
        return builder.toString();
    }
}

