/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import com.buschmais.jqassistant.plugin.xml.api.scanner.AbstractXmlFileScannerPlugin;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XMLFileFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomFileScannerPlugin
extends AbstractXmlFileScannerPlugin<MavenPomXmlDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenPomFileScannerPlugin.class);
    private MavenXpp3Reader mavenXpp3Reader;

    public void initialize() {
        this.mavenXpp3Reader = new MavenXpp3Reader();
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean hasXMLExtension = path.toLowerCase().endsWith(".xml");
        boolean isPomXML = path.toLowerCase().endsWith("pom.xml");
        boolean hasPomExtension = path.toLowerCase().endsWith(".pom");
        boolean identifiedByExtension = isPomXML || hasPomExtension;
        boolean isMavenPOM = !identifiedByExtension && hasXMLExtension ? XMLFileFilter.rootElementMatches((FileResource)item, (String)path, (String)"project", (String)"http://maven.apache.org/POM/4.0.0") : identifiedByExtension;
        return isMavenPOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenPomXmlDescriptor scan(FileResource item, MavenPomXmlDescriptor mavenPomXmlDescriptor, String path, Scope scope, Scanner scanner) throws IOException {
        Model model = this.getModel(item, scanner);
        if (model != null) {
            scanner.getContext().push(MavenPomDescriptor.class, (Object)mavenPomXmlDescriptor);
            try {
                MavenPomXmlDescriptor result = (MavenPomXmlDescriptor)scanner.scan((Object)model, path, scope);
                result.setValid(true);
                MavenPomXmlDescriptor mavenPomXmlDescriptor2 = result;
                return mavenPomXmlDescriptor2;
            }
            finally {
                scanner.getContext().pop(MavenPomDescriptor.class);
            }
        }
        mavenPomXmlDescriptor.setValid(false);
        return mavenPomXmlDescriptor;
    }

    private Model getModel(FileResource item, Scanner scanner) throws IOException {
        PomModelBuilder pomModelBuilder = (PomModelBuilder)scanner.getContext().peekOrDefault(PomModelBuilder.class, null);
        if (pomModelBuilder != null) {
            return pomModelBuilder.getModel(item.getFile());
        }
        Model model = null;
        try (InputStream stream = item.createStream();){
            model = this.mavenXpp3Reader.read(stream);
        }
        catch (XmlPullParserException e) {
            String msg = "Cannot read POM descriptor from " + item.getFile().getAbsolutePath() + ".";
            LOGGER.warn(msg, (Throwable)e);
        }
        return model;
    }
}

