/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.api.ScopeHelper;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaClassesDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.junit.api.scanner.JunitScope;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenRepositoryArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenMainArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenTestArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.EffectiveModel;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency.DependencyScanner;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.dependency.GraphResolver;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectScannerPlugin
extends AbstractScannerPlugin<MavenProject, MavenProjectDirectoryDescriptor> {
    private static final String PROPERTY_NAME_DEPENDENCIES_SCAN = "maven3.dependencies.scan";
    private static final String PROPERTY_NAME_DEPENDENCIES_INCLUDES = "maven3.dependencies.includes";
    private static final String PROPERTY_NAME_DEPENDENCIES_EXCLUDES = "maven3.dependencies.excludes";
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectScannerPlugin.class);
    private final ScopeHelper scopeHelper = new ScopeHelper(LOGGER);
    private final DependencyScanner dependencyScanner;
    private boolean scanDependencies;
    private ArtifactFilter dependencyFilter = null;

    public MavenProjectScannerPlugin() {
        this(new DependencyScanner(new GraphResolver()));
    }

    MavenProjectScannerPlugin(DependencyScanner dependencyScanner) {
        this.dependencyScanner = dependencyScanner;
    }

    protected void configure() {
        this.scanDependencies = this.getBooleanProperty(PROPERTY_NAME_DEPENDENCIES_SCAN, false);
        String dependencyFilterIncludes = this.getStringProperty(PROPERTY_NAME_DEPENDENCIES_INCLUDES, null);
        String dependencyFilterExcludes = this.getStringProperty(PROPERTY_NAME_DEPENDENCIES_EXCLUDES, null);
        this.dependencyFilter = new ArtifactFilter(dependencyFilterIncludes, dependencyFilterExcludes);
    }

    public boolean accepts(MavenProject item, String path, Scope scope) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProjectDirectoryDescriptor scan(MavenProject project, String projectPath, Scope scope, Scanner scanner) {
        ScannerContext context = scanner.getContext();
        MavenSession mavenSession = (MavenSession)context.peek(MavenSession.class);
        File localRepositoryDirectory = mavenSession.getProjectBuildingRequest().getRepositorySession().getLocalRepository().getBasedir();
        FileResolver fileResolver = (FileResolver)context.peek(FileResolver.class);
        MavenRepositoryArtifactResolver artifactResolver = new MavenRepositoryArtifactResolver(localRepositoryDirectory, fileResolver);
        context.push(ArtifactResolver.class, (Object)artifactResolver);
        try {
            MavenProjectDirectoryDescriptor projectDescriptor = this.scanClasses(project, scanner, mavenSession, artifactResolver);
            this.addProjectDetails(project, projectDescriptor, scanner);
            this.scanTestReports(project, scanner);
            this.scanIncludes(project, scanner, projectDescriptor);
            MavenProjectDirectoryDescriptor mavenProjectDirectoryDescriptor = projectDescriptor;
            return mavenProjectDirectoryDescriptor;
        }
        finally {
            context.pop(ArtifactResolver.class);
        }
    }

    private MavenProjectDirectoryDescriptor scanClasses(MavenProject project, Scanner scanner, MavenSession mavenSession, MavenRepositoryArtifactResolver artifactResolver) {
        ScannerContext context = scanner.getContext();
        MavenProjectDirectoryDescriptor projectDescriptor = this.resolveProject(project, MavenProjectDirectoryDescriptor.class, context);
        Artifact artifact = project.getArtifact();
        MavenMainArtifactDescriptor mainArtifactDescriptor = this.getMavenArtifactDescriptor(new MavenArtifactCoordinates(artifact, false), MavenMainArtifactDescriptor.class, artifactResolver, scanner);
        projectDescriptor.getCreatesArtifacts().add(mainArtifactDescriptor);
        MavenTestArtifactDescriptor testArtifactDescriptor = null;
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        if (testOutputDirectory != null) {
            testArtifactDescriptor = this.getMavenArtifactDescriptor(new MavenArtifactCoordinates(artifact, true), MavenTestArtifactDescriptor.class, artifactResolver, scanner);
            DependsOnDescriptor dependsOnDescriptor = (DependsOnDescriptor)context.getStore().create((Descriptor)testArtifactDescriptor, DependsOnDescriptor.class, (Descriptor)mainArtifactDescriptor);
            dependsOnDescriptor.setScope("compile");
            projectDescriptor.getCreatesArtifacts().add(testArtifactDescriptor);
        }
        this.resolveDependencyGraph(project, mainArtifactDescriptor, testArtifactDescriptor, scanner, mavenSession);
        this.scanClassesDirectory(mainArtifactDescriptor, project.getBuild().getOutputDirectory(), scanner);
        if (testOutputDirectory != null) {
            this.scanClassesDirectory(testArtifactDescriptor, testOutputDirectory, scanner);
        }
        return projectDescriptor;
    }

    private void scanTestReports(MavenProject project, Scanner scanner) {
        String surefireReports = project.getBuild().getDirectory() + "/surefire-reports";
        this.scanFile(new File(surefireReports), surefireReports, (Scope)JunitScope.TESTREPORTS, scanner);
        String failsafeReports = project.getBuild().getDirectory() + "/failsafe-reports";
        this.scanFile(new File(failsafeReports), failsafeReports, (Scope)JunitScope.TESTREPORTS, scanner);
    }

    private void scanIncludes(MavenProject project, Scanner scanner, MavenProjectDirectoryDescriptor projectDescriptor) {
        File basedir = project.getBasedir();
        Consumer<Descriptor> scanIncludeConsumer = descriptor -> {
            if (descriptor instanceof FileDescriptor) {
                projectDescriptor.getContains().add((FileDescriptor)descriptor);
            }
        };
        scanner.getConfiguration().include().ifPresent(include -> {
            this.scanInclude(include.files(), (fileName, s) -> this.scanFile(basedir.toPath().resolve((String)fileName).toFile(), (String)fileName, (Scope)s, scanner), scanIncludeConsumer, scanner);
            this.scanInclude(include.urls(), (url, s) -> {
                try {
                    return scanner.scan((Object)new URI((String)url), url, s);
                }
                catch (URISyntaxException e) {
                    LOGGER.warn("Cannot convert URL '" + url + "' to URI.", (Throwable)e);
                    return null;
                }
            }, scanIncludeConsumer, scanner);
        });
    }

    private void scanInclude(Optional<List<String>> resources, BiFunction<String, Scope, Descriptor> scanAction, Consumer<Descriptor> descriptorConsumer, Scanner scanner) {
        resources.ifPresent(r -> {
            for (ScopeHelper.ScopedResource scopedResource : this.scopeHelper.getScopedResources(r)) {
                String scopeName;
                Scope resolvedScope;
                String resource = scopedResource.getResource();
                Descriptor descriptor = (Descriptor)scanAction.apply(resource, resolvedScope = scanner.resolveScope(scopeName = scopedResource.getScopeName()));
                if (descriptor == null) continue;
                descriptorConsumer.accept(descriptor);
            }
        });
    }

    private <T extends MavenArtifactDescriptor> T getMavenArtifactDescriptor(Coordinates coordinates, Class<T> type, ArtifactResolver artifactResolver, Scanner scanner) {
        MavenArtifactDescriptor mavenArtifactDescriptor = artifactResolver.resolve(coordinates, scanner.getContext());
        return (T)((MavenArtifactDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)mavenArtifactDescriptor, type));
    }

    protected <T extends MavenProjectDescriptor> T resolveProject(MavenProject project, Class<T> expectedType, ScannerContext scannerContext) {
        String id;
        Store store = scannerContext.getStore();
        MavenProjectDescriptor projectDescriptor = (MavenProjectDescriptor)store.find(MavenProjectDescriptor.class, id = project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
        if (projectDescriptor == null) {
            projectDescriptor = (MavenProjectDescriptor)store.create(expectedType, id);
            projectDescriptor.setName(project.getName());
            projectDescriptor.setGroupId(project.getGroupId());
            projectDescriptor.setArtifactId(project.getArtifactId());
            projectDescriptor.setVersion(project.getVersion());
            projectDescriptor.setPackaging(project.getPackaging());
            projectDescriptor.setFullQualifiedName(id);
        } else if (!expectedType.isAssignableFrom(projectDescriptor.getClass())) {
            projectDescriptor = (MavenProjectDescriptor)store.addDescriptorType((Descriptor)projectDescriptor, expectedType);
        }
        return (T)((MavenProjectDescriptor)expectedType.cast(projectDescriptor));
    }

    private void resolveDependencyGraph(MavenProject project, MavenArtifactDescriptor mainDescriptor, MavenArtifactDescriptor testDescriptor, Scanner scanner, MavenSession mavenSession) {
        ScannerContext context = scanner.getContext();
        ProjectBuildingRequest projectBuildingRequest = mavenSession.getProjectBuildingRequest();
        ArtifactRepository localRepository = mavenSession.getLocalRepository();
        DependencyGraphBuilder dependencyGraphBuilder = (DependencyGraphBuilder)context.peek(DependencyGraphBuilder.class);
        RepositorySystemSession repositorySession = projectBuildingRequest.getRepositorySession();
        DefaultRepositorySystemSession repositorySystemSession = this.getVerboseRepositorySystemSession(repositorySession);
        ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(project, projectBuildingRequest, repositorySystemSession);
        DependencyNode rootNode = null;
        try {
            rootNode = dependencyGraphBuilder.buildDependencyGraph(buildingRequest, null);
        }
        catch (DependencyGraphBuilderException e) {
            LOGGER.warn("Cannot resolve dependency graph for " + project, (Throwable)e);
        }
        if (rootNode != null) {
            this.dependencyScanner.evaluate(rootNode, mainDescriptor, testDescriptor, this.scanDependencies, this.dependencyFilter, localRepository, scanner);
        }
    }

    private DefaultRepositorySystemSession getVerboseRepositorySystemSession(RepositorySystemSession repositorySession) {
        DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession(repositorySession);
        repositorySystemSession.setConfigProperty("aether.conflictResolver.verbose", (Object)"true");
        return repositorySystemSession;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject project, ProjectBuildingRequest projectBuildingRequest, DefaultRepositorySystemSession repositorySystemSession) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(projectBuildingRequest);
        buildingRequest.setRepositorySession((RepositorySystemSession)repositorySystemSession);
        buildingRequest.setProject(project);
        return buildingRequest;
    }

    private void addProjectDetails(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        ScannerContext scannerContext = scanner.getContext();
        this.addParent(project, projectDescriptor, scannerContext);
        this.addModules(project, projectDescriptor, scannerContext);
        this.addModel(project, projectDescriptor, scanner);
    }

    private void addModel(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        File pomXmlFile = project.getFile();
        FileDescriptor mavenPomXmlDescriptor = (FileDescriptor)scanner.scan((Object)pomXmlFile, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        projectDescriptor.setModel(mavenPomXmlDescriptor);
        MavenPomDescriptor effectiveModelDescriptor = (MavenPomDescriptor)scanner.getContext().getStore().create(MavenPomDescriptor.class);
        EffectiveModel model = new EffectiveModel(project.getModel());
        scanner.getContext().push(MavenPomDescriptor.class, (Object)effectiveModelDescriptor);
        scanner.scan((Object)model, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        scanner.getContext().pop(MavenPomDescriptor.class);
        projectDescriptor.setEffectiveModel(effectiveModelDescriptor);
    }

    private void addParent(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            MavenProjectDescriptor parentDescriptor = this.resolveProject(parent, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.setParent(parentDescriptor);
        }
    }

    private void addModules(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        File projectDirectory = project.getBasedir();
        HashSet<File> modules = new HashSet<File>();
        for (String moduleName : project.getModules()) {
            File module = new File(projectDirectory, moduleName);
            modules.add(module);
        }
        for (MavenProject module : project.getCollectedProjects()) {
            if (!modules.contains(module.getBasedir())) continue;
            MavenProjectDescriptor moduleDescriptor = this.resolveProject(module, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void scanClassesDirectory(MavenArtifactDescriptor artifactDescriptor, String directoryName, Scanner scanner) {
        File directory = new File(directoryName);
        if (directory.exists()) {
            this.scanArtifact(artifactDescriptor, directory, directoryName, scanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaArtifactFileDescriptor scanArtifact(ArtifactDescriptor artifactDescriptor, File file, String path, Scanner scanner) {
        JavaArtifactFileDescriptor javaArtifactFileDescriptor = (JavaArtifactFileDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)artifactDescriptor, JavaClassesDirectoryDescriptor.class);
        ScannerContext context = scanner.getContext();
        context.push(JavaArtifactFileDescriptor.class, (Object)javaArtifactFileDescriptor);
        try {
            JavaArtifactFileDescriptor javaArtifactFileDescriptor2 = (JavaArtifactFileDescriptor)this.scanFile(file, path, (Scope)JavaScope.CLASSPATH, scanner);
            return javaArtifactFileDescriptor2;
        }
        finally {
            context.pop(JavaArtifactFileDescriptor.class);
        }
    }

    private <F extends FileDescriptor> F scanFile(File file, String path, Scope scope, Scanner scanner) {
        if (file.exists()) {
            return (F)((FileDescriptor)scanner.scan((Object)file, path, scope));
        }
        LOGGER.debug(file.getAbsolutePath() + " does not exist, skipping.");
        return null;
    }
}

