/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.api.model.YMLDocumentDescriptor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AliasLinker;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AliasNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AnchorCache;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.AnchorHandler;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.Callback;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.DocumentNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.MapNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.NodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.ScalarNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.SequenceNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.graph.SimpleKeyNodeProcessor;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.StreamNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class GraphGenerator {
    private final List<NodeProcessor> processors;

    public GraphGenerator(Store store) {
        AnchorCache anchorCache = new AnchorCache();
        AliasLinker aliasLinker = new AliasLinker(store, anchorCache);
        AliasNodeProcessor aliasNodeProcessor = new AliasNodeProcessor(store, this, anchorCache);
        AnchorHandler anchorHandler = new AnchorHandler(store, anchorCache);
        DocumentNodeProcessor documentNodeProcessor = new DocumentNodeProcessor(store, this);
        SequenceNodeProcessor sequenceNodeProcessor = new SequenceNodeProcessor(store, this, anchorHandler, aliasLinker);
        ScalarNodeProcessor scalarNodeProcessor = new ScalarNodeProcessor(store, anchorHandler);
        SimpleKeyNodeProcessor simpleKeyNodeProcessor = new SimpleKeyNodeProcessor(store, anchorHandler);
        MapNodeProcessor mapNodeProcessor = new MapNodeProcessor(store, this, anchorHandler, aliasLinker);
        this.processors = Arrays.asList(aliasNodeProcessor, documentNodeProcessor, mapNodeProcessor, sequenceNodeProcessor, scalarNodeProcessor, simpleKeyNodeProcessor);
    }

    public Collection<YMLDocumentDescriptor> generate(StreamNode root) {
        ArrayList<YMLDocumentDescriptor> result = new ArrayList<YMLDocumentDescriptor>(1);
        Callback<YMLDocumentDescriptor> callback = result::add;
        root.getDocuments().forEach(documentNode -> this.traverse((AbstractBaseNode)documentNode, (Callback<? extends YMLDescriptor>)callback, Mode.STANDARD));
        return result;
    }

    void traverse(AbstractBaseNode node, Callback<? extends YMLDescriptor> callback, Mode mode) {
        Supplier<IllegalStateException> exceptionSupplier = () -> {
            String message = String.format("Failed to find processor for node class '%s'", node.getClass().getCanonicalName());
            return new IllegalStateException(message);
        };
        this.processors.stream().filter(h -> h.accepts(node)).findFirst().orElseThrow(exceptionSupplier).process(node, callback, mode);
    }

    public static enum Mode {
        STANDARD(true),
        REFERENCE(false);

        private final boolean inStandardMode;

        private Mode(boolean mode) {
            this.inStandardMode = mode;
        }

        public boolean isInReferenceMode() {
            return !this.inStandardMode;
        }

        public boolean isInStandardMode() {
            return this.inStandardMode;
        }
    }
}

