/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.cache;

import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.cache.TransactionalCache;
import com.buschmais.xo.impl.instancelistener.InstanceListenerService;
import com.buschmais.xo.spi.datastore.DatastorePropertyManager;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

public class CacheSynchronizationService<Entity, Relation> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private final XOUnit xoUnit;

    public CacheSynchronizationService(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, XOUnit xoUnit) {
        this.sessionContext = sessionContext;
        this.xoUnit = xoUnit;
    }

    public void flush() {
        DatastoreSession<?, Entity, ?, ?, ?, Relation, ?, ?, ?> datastoreSession = this.sessionContext.getDatastoreSession();
        InstanceListenerService instanceListenerService = this.sessionContext.getInstanceListenerService();
        this.flush(this.sessionContext.getRelationCache(), (AbstractInstanceManager)this.sessionContext.getRelationInstanceManager(), (DatastorePropertyManager)datastoreSession.getDatastoreRelationManager(), instanceListenerService);
        this.flush(this.sessionContext.getEntityCache(), (AbstractInstanceManager)this.sessionContext.getEntityInstanceManager(), (DatastorePropertyManager)datastoreSession.getDatastoreEntityManager(), instanceListenerService);
    }

    private <T> void flush(TransactionalCache<?> cache, AbstractInstanceManager<?, T> instanceManager, DatastorePropertyManager<T, ?> datastoreManager, InstanceListenerService instanceListenerService) {
        Collection<?> writtenInstances = cache.writtenInstances();
        if (!writtenInstances.isEmpty()) {
            ArrayList<T> entities = new ArrayList<T>(writtenInstances.size());
            for (Object instance : writtenInstances) {
                T entity = instanceManager.getDatastoreType(instance);
                entities.add(entity);
                instanceListenerService.preUpdate(instance);
                this.validateInstance(instance);
                instanceListenerService.postUpdate(instance);
            }
            datastoreManager.flush(entities);
            cache.flush();
        }
    }

    public void clear() {
        DatastoreSession<?, Entity, ?, ?, ?, Relation, ?, ?, ?> datastoreSession = this.sessionContext.getDatastoreSession();
        this.clear(this.sessionContext.getRelationCache(), (AbstractInstanceManager)this.sessionContext.getRelationInstanceManager(), (DatastorePropertyManager)datastoreSession.getDatastoreRelationManager());
        this.clear(this.sessionContext.getEntityCache(), (AbstractInstanceManager)this.sessionContext.getEntityInstanceManager(), (DatastorePropertyManager)datastoreSession.getDatastoreEntityManager());
    }

    private <T> void clear(TransactionalCache<?> cache, AbstractInstanceManager<?, T> instanceManager, DatastorePropertyManager<T, ?> datastoreManager) {
        Collection<?> instances = cache.readInstances();
        for (Object instance : instances) {
            T datastoreType = instanceManager.getDatastoreType(instance);
            if (datastoreType == null) continue;
            datastoreManager.afterCompletion(datastoreType, this.xoUnit.isClearAfterCompletion());
        }
        cache.clear();
    }

    private void validateInstance(Object instance) {
        Set<ConstraintViolation<Object>> constraintViolations;
        if (!ValidationMode.NONE.equals((Object)this.xoUnit.getValidationMode()) && !(constraintViolations = this.sessionContext.getInstanceValidationService().validate(instance)).isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

