/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.cache;

import com.buschmais.xo.impl.cache.ReferenceCache;
import com.buschmais.xo.impl.cache.WeakReferenceCache;
import java.util.Collection;

public class TransactionalCache<Id> {
    private final WeakReferenceCache<CacheKey> readCache = new WeakReferenceCache();
    private final ReferenceCache<Id> writeCache = new ReferenceCache();

    public void put(Id id, Object value, Mode mode) {
        if (Mode.WRITE.equals((Object)mode)) {
            this.writeCache.put(id, value);
        }
        this.readCache.put(new CacheKey<Id>(id), value);
    }

    public Object get(Id id, Mode mode) {
        Object value = this.writeCache.get(id);
        if (value == null && (value = this.readCache.get(new CacheKey<Id>(id))) != null && Mode.WRITE.equals((Object)mode)) {
            this.writeCache.put(id, value);
        }
        return value;
    }

    public void remove(Id id) {
        this.readCache.remove(new CacheKey<Id>(id));
        this.writeCache.remove(id);
    }

    public void flush() {
        this.writeCache.clear();
    }

    public void clear() {
        this.writeCache.clear();
        this.readCache.clear();
    }

    public Collection<?> readInstances() {
        return this.readCache.values();
    }

    public Collection<?> writtenInstances() {
        return this.writeCache.values();
    }

    public static enum Mode {
        READ,
        WRITE;

    }

    private static class CacheKey<Id> {
        private final Id id;

        public CacheKey(Id id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Id this$id = this.id;
            Id other$id = other.id;
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Id $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "TransactionalCache.CacheKey(id=" + this.id + ")";
        }
    }
}

