/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.converter;

import com.buschmais.xo.api.XOException;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.util.Collection;

public final class ValueConverter {
    public static Object convert(Object value, Class<?> propertyType) {
        if (value != null) {
            if (propertyType.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (Enum.class.isAssignableFrom(propertyType)) {
                return Enum.valueOf(propertyType, (String)value);
            }
            if (propertyType.isArray()) {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    return ValueConverter.toArray((Collection)value, propertyType.getComponentType());
                }
                if (value.getClass().isArray()) {
                    return ValueConverter.toArray(value, propertyType.getComponentType());
                }
            } else {
                if (propertyType.isPrimitive()) {
                    return ValueConverter.convertPrimitive(value, propertyType);
                }
                if (Primitives.isWrapperType(propertyType)) {
                    return ValueConverter.convertPrimitive(value, Primitives.unwrap(propertyType));
                }
            }
            throw new XOException("Cannot convert value '" + value + "' of type " + value.getClass() + " to " + propertyType);
        }
        if (Boolean.TYPE.equals(propertyType)) {
            return false;
        }
        if (Short.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Integer.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Long.TYPE.equals(propertyType)) {
            return 0L;
        }
        if (Float.TYPE.equals(propertyType)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(propertyType)) {
            return 0.0;
        }
        if (Character.TYPE.equals(propertyType)) {
            return 0;
        }
        if (Byte.TYPE.equals(propertyType)) {
            return 0;
        }
        return null;
    }

    private static Object toArray(Object values, Class<?> componentType) {
        int length = Array.getLength(values);
        Object array = Array.newInstance(componentType, length);
        for (int index = 0; index < length; ++index) {
            Array.set(array, index, ValueConverter.convert(Array.get(values, index), componentType));
        }
        return array;
    }

    private static Object toArray(Collection<?> values, Class<?> componentType) {
        Object array = Array.newInstance(componentType, values.size());
        int index = 0;
        for (Object value : values) {
            Array.set(array, index, ValueConverter.convert(value, componentType));
            ++index;
        }
        return array;
    }

    private static Object convertPrimitive(Object value, Class<?> propertyType) {
        if (Number.class.isAssignableFrom(value.getClass())) {
            Number number = (Number)value;
            if (Byte.TYPE.equals(propertyType)) {
                return number.byteValue();
            }
            if (Short.TYPE.equals(propertyType)) {
                return number.shortValue();
            }
            if (Integer.TYPE.equals(propertyType)) {
                return number.intValue();
            }
            if (Long.TYPE.equals(propertyType)) {
                return number.longValue();
            }
            if (Float.TYPE.equals(propertyType)) {
                return Float.valueOf(number.floatValue());
            }
            if (Double.TYPE.equals(propertyType)) {
                return number.doubleValue();
            }
        } else if (String.class.isAssignableFrom(value.getClass()) && (Character.class.equals(propertyType) || Character.TYPE.equals(propertyType))) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return value;
    }

    private ValueConverter() {
    }
}

