/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.common.object;

import com.buschmais.xo.api.metadata.method.MethodMetadata;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.api.metadata.type.TypeMetadata;
import com.buschmais.xo.impl.proxy.common.object.AbstractToStringMethod;
import com.buschmais.xo.spi.datastore.DatastorePropertyManager;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractDatastoreTypeToStringMethod<T>
extends AbstractToStringMethod<T> {
    @Override
    protected Map<String, Object> getProperties(T datastoreType) {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        for (TypeMetadata type : this.getDynamicType(datastoreType).getMetadata()) {
            this.addProperties(datastoreType, type, properties);
        }
        return properties;
    }

    private void addProperties(T datastoreType, TypeMetadata type, SortedMap<String, Object> properties) {
        for (MethodMetadata methodMetadata : type.getProperties()) {
            PrimitivePropertyMethodMetadata propertyMethodMetadata;
            Object value;
            if (!(methodMetadata instanceof PrimitivePropertyMethodMetadata) || (value = this.getProperty(datastoreType, propertyMethodMetadata = (PrimitivePropertyMethodMetadata)methodMetadata)) == null) continue;
            properties.put(propertyMethodMetadata.getAnnotatedMethod().getName(), value);
        }
        for (TypeMetadata superType : type.getSuperTypes()) {
            this.addProperties(datastoreType, superType, properties);
        }
    }

    private final Object getProperty(T datastoreType, PrimitivePropertyMethodMetadata propertyMethodMetadata) {
        DatastorePropertyManager<T, ?> datastorePropertyManager = this.getDatastorePropertyManager();
        return datastorePropertyManager.hasProperty(datastoreType, propertyMethodMetadata) ? datastorePropertyManager.getProperty(datastoreType, propertyMethodMetadata) : null;
    }

    protected abstract CompositeTypeMetadata<?> getDynamicType(T var1);

    protected abstract DatastorePropertyManager<T, ?> getDatastorePropertyManager();
}

