/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.query;

import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.api.annotation.Flush;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.plugin.QueryLanguagePluginRepository;
import com.buschmais.xo.impl.query.QueryResultIterableImpl;
import com.buschmais.xo.impl.transaction.TransactionalResultIterator;
import com.buschmais.xo.spi.datastore.DatastoreQuery;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import com.buschmais.xo.spi.plugin.QueryLanguagePlugin;
import com.buschmais.xo.spi.session.InstanceManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class XOQueryImpl<T, QL extends Annotation, QE, Entity, Relation>
implements Query<T> {
    private Class<? extends Annotation> queryLanguage = null;
    private Boolean flush = null;
    private final QE expression;
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private final QueryLanguagePluginRepository queryLanguagePluginManager;
    private final Class<?> returnType;
    private final Collection<? extends Class<?>> returnTypes;
    private final InstanceManager<?, Entity> entityInstanceManager;
    private final InstanceManager<?, Relation> relationInstanceManager;
    private Map<String, Object> parameters = null;

    public XOQueryImpl(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, QE expression, Class<?> returnType, Collection<? extends Class<?>> returnTypes) {
        this.sessionContext = sessionContext;
        this.entityInstanceManager = sessionContext.getEntityInstanceManager();
        this.relationInstanceManager = sessionContext.getRelationInstanceManager();
        this.queryLanguagePluginManager = (QueryLanguagePluginRepository)sessionContext.getPluginRepositoryManager().getPluginManager(QueryLanguagePlugin.class);
        this.expression = expression;
        this.returnType = returnType;
        this.returnTypes = returnTypes;
    }

    public XOQueryImpl(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, QE expression) {
        this(sessionContext, expression, null, Collections.emptyList());
    }

    public XOQueryImpl(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, QE expression, Class<?> returnType) {
        this(sessionContext, expression, returnType, Collections.emptyList());
    }

    public Query<T> using(Class<? extends Annotation> queryLanguage) {
        this.queryLanguage = queryLanguage;
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor((Object)this, new Class[]{Query.class});
    }

    public Query<T> withParameter(String name, Object value) {
        Object oldValue;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        if ((oldValue = this.parameters.put(name, this.convertParameter(value))) != null) {
            throw new XOException("Parameter '" + name + "' has already been assigned to value '" + value + "'.");
        }
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor((Object)this, new Class[]{Query.class});
    }

    public Query<T> withParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            throw new XOException("Parameters must not be null.");
        }
        if (this.parameters != null) {
            throw new XOException("Parameters have already been assigned: " + parameters);
        }
        HashMap<String, Object> convertedParameters = new HashMap<String, Object>(parameters.size(), 1.0f);
        for (Map.Entry<String, Object> parameterEntry : parameters.entrySet()) {
            String name = parameterEntry.getKey();
            Object value = parameterEntry.getValue();
            value = this.convertParameter(value);
            convertedParameters.put(name, value);
        }
        this.parameters = convertedParameters;
        return (Query)this.sessionContext.getInterceptorFactory().addInterceptor((Object)this, new Class[]{Query.class});
    }

    public Query<T> flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    public Query.Result<T> execute() {
        TransactionalResultIterator iterator;
        Map<Object, Object> effectiveParameters;
        QueryLanguagePlugin queryLanguagePlugin;
        DatastoreSession<?, Entity, ?, ?, ?, Relation, ?, ?, ?> datastoreSession = this.sessionContext.getDatastoreSession();
        if (this.queryLanguage == null) {
            this.queryLanguage = datastoreSession.getDefaultQueryLanguage();
        }
        DatastoreQuery query = (queryLanguagePlugin = (QueryLanguagePlugin)this.queryLanguagePluginManager.get(this.queryLanguage)) != null ? queryLanguagePlugin.createQuery(this.sessionContext.getDatastoreSession()) : this.sessionContext.getDatastoreSession().createQuery(this.queryLanguage);
        Map<Object, Object> map = effectiveParameters = this.parameters != null ? this.parameters : Collections.emptyMap();
        if (this.expression instanceof String) {
            this.flush(null);
            iterator = query.execute((String)this.expression, effectiveParameters);
        } else if (this.expression instanceof AnnotatedElement) {
            AnnotatedElement annotatedElement = (AnnotatedElement)this.expression;
            Annotation queryAnnotation = this.sessionContext.getMetadataProvider().getQuery(annotatedElement);
            if (queryAnnotation == null) {
                throw new XOException("Cannot find query annotation on element " + this.expression.toString());
            }
            this.flush(annotatedElement);
            iterator = query.execute(queryAnnotation, effectiveParameters);
        } else {
            throw new XOException("Expression type is not supported: " + this.expression);
        }
        SortedSet<Class<?>> resultTypes = this.getResultTypes();
        XOTransaction xoTransaction = this.sessionContext.getXOTransaction();
        return (Query.Result)this.sessionContext.getInterceptorFactory().addInterceptor(new QueryResultIterableImpl(this.sessionContext, xoTransaction != null ? new TransactionalResultIterator(iterator, xoTransaction) : iterator, resultTypes), new Class[]{Query.Result.class});
    }

    private void flush(AnnotatedElement annotatedElement) {
        boolean doFlush;
        if (this.flush != null) {
            doFlush = this.flush;
        } else {
            Flush autoFlushAnnotation = annotatedElement != null ? annotatedElement.getAnnotation(Flush.class) : null;
            boolean bl = doFlush = autoFlushAnnotation == null || autoFlushAnnotation.value();
        }
        if (doFlush) {
            this.sessionContext.getCacheSynchronizationService().flush();
        }
    }

    private Object convertParameter(Object value) {
        if (this.entityInstanceManager.isInstance(value)) {
            return this.entityInstanceManager.getDatastoreType(value);
        }
        if (this.relationInstanceManager.isInstance(value)) {
            return this.relationInstanceManager.getDatastoreType(value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object o : collection) {
                values.add(this.convertParameter(o));
            }
            return values;
        }
        return value;
    }

    private SortedSet<Class<?>> getResultTypes() {
        TreeSet resultTypes = new TreeSet(Comparator.comparing(Class::getName));
        if (this.returnType != null) {
            resultTypes.add(this.returnType);
        }
        resultTypes.addAll(this.returnTypes);
        return resultTypes;
    }
}

