/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.api;

import lombok.Generated;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogProvider
implements LogProvider {
    public static final Slf4jLogProvider INSTANCE = new Slf4jLogProvider();

    public Log getLog(Class<?> loggingClass) {
        return new Slf4jLog(LoggerFactory.getLogger(loggingClass));
    }

    public Log getLog(String name) {
        return new Slf4jLog(LoggerFactory.getLogger((String)name));
    }

    @Generated
    private Slf4jLogProvider() {
    }

    private static final class Slf4jLog
    implements Log {
        private final Logger logger;

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void debug(String message, Throwable throwable) {
            this.logger.debug(message, throwable);
        }

        public void debug(String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format(format, arguments));
            }
        }

        public void info(String message) {
            this.logger.info(message);
        }

        public void info(String message, Throwable throwable) {
            this.logger.info(message, throwable);
        }

        public void info(String format, Object ... arguments) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format(format, arguments));
            }
        }

        public void warn(String message) {
            this.logger.warn(message);
        }

        public void warn(String message, Throwable throwable) {
            this.logger.warn(message, throwable);
        }

        public void warn(String format, Object ... arguments) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(String.format(format, arguments));
            }
        }

        public void error(String message) {
            this.logger.error(message);
        }

        public void error(String message, Throwable throwable) {
            this.logger.error(message, throwable);
        }

        public void error(String format, Object ... arguments) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(String.format(format, arguments));
            }
        }

        @Generated
        public Slf4jLog(Logger logger) {
            this.logger = logger;
        }
    }
}

