/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.api.metadata.type.CompositeTypeMetadata;
import com.buschmais.xo.api.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.neo4j.embedded.impl.datastore.AbstractEmbeddedPropertyManager;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.spi.helper.MetadataHelper;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class EmbeddedEntityManager
extends AbstractEmbeddedPropertyManager<EmbeddedNode>
implements DatastoreEntityManager<Long, EmbeddedNode, NodeMetadata<EmbeddedLabel>, EmbeddedLabel, PropertyMetadata> {
    private final EmbeddedDatastoreTransaction datastoreTransaction;

    public EmbeddedEntityManager(EmbeddedDatastoreTransaction datastoreTransaction) {
        this.datastoreTransaction = datastoreTransaction;
    }

    public boolean isEntity(Object o) {
        return EmbeddedNode.class.isAssignableFrom(o.getClass());
    }

    public Set<EmbeddedLabel> getEntityDiscriminators(EmbeddedNode node) {
        return node.getLabels();
    }

    public Long getEntityId(EmbeddedNode entity) {
        return entity.getId();
    }

    public EmbeddedNode createEntity(CompositeTypeMetadata<EntityTypeMetadata<NodeMetadata<EmbeddedLabel>>> types, Set<EmbeddedLabel> discriminators, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        Label[] labels = new Label[discriminators.size()];
        int i = 0;
        for (EmbeddedLabel discriminator : discriminators) {
            labels[i++] = discriminator.getDelegate();
        }
        Node delegate = this.datastoreTransaction.getTransaction().createNode(labels);
        EmbeddedNode node = new EmbeddedNode(this.datastoreTransaction, delegate);
        this.setProperties(node, example);
        return node;
    }

    public void deleteEntity(EmbeddedNode entity) {
        entity.delete();
    }

    public EmbeddedNode findEntityById(EntityTypeMetadata<NodeMetadata<EmbeddedLabel>> metadata, EmbeddedLabel label, Long id) {
        return new EmbeddedNode(this.datastoreTransaction, this.datastoreTransaction.getTransaction().getNodeById(id.longValue()));
    }

    public ResultIterator<EmbeddedNode> findEntity(EntityTypeMetadata<NodeMetadata<EmbeddedLabel>> entityTypeMetadata, EmbeddedLabel discriminator, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> values) {
        if (values.size() > 1) {
            throw new XOException("Only one property value is supported for find operation");
        }
        Map.Entry<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> entry = values.entrySet().iterator().next();
        Object value = entry.getValue();
        PropertyMetadata propertyMetadata = MetadataHelper.getIndexedPropertyMetadata(entityTypeMetadata, entry.getKey());
        final ResourceIterator iterator = this.datastoreTransaction.getTransaction().findNodes(discriminator.getDelegate(), propertyMetadata.getName(), value);
        return new ResultIterator<EmbeddedNode>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public EmbeddedNode next() {
                return new EmbeddedNode(EmbeddedEntityManager.this.datastoreTransaction, (Node)iterator.next());
            }

            public void remove() {
                throw new XOException("Remove operation is not supported for find results.");
            }

            public void close() {
                iterator.close();
            }
        };
    }

    public void addDiscriminators(CompositeTypeMetadata<EntityTypeMetadata<NodeMetadata<EmbeddedLabel>>> types, EmbeddedNode node, Set<EmbeddedLabel> labels) {
        for (EmbeddedLabel label : labels) {
            node.addLabel(label);
        }
    }

    public void removeDiscriminators(CompositeTypeMetadata<EntityTypeMetadata<NodeMetadata<EmbeddedLabel>>> removedTypes, EmbeddedNode node, Set<EmbeddedLabel> labels) {
        for (EmbeddedLabel label : labels) {
            node.removeLabel(label);
        }
    }

    public void afterCompletion(EmbeddedNode node, boolean clear) {
        if (clear) {
            node.clear();
        }
    }

    public void flush(Iterable<EmbeddedNode> nodes) {
        for (EmbeddedNode node : nodes) {
            node.flush();
        }
    }
}

