/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.datastore;

import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedLabel;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNode;
import com.buschmais.xo.neo4j.spi.AbstractNeo4jRepository;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.spi.session.XOSession;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class EmbeddedRepository
extends AbstractNeo4jRepository<EmbeddedLabel> {
    private final EmbeddedDatastoreTransaction datastoreTransaction;

    protected EmbeddedRepository(EmbeddedDatastoreTransaction datastoreTransaction, XOSession<NodeMetadata<EmbeddedLabel>, EmbeddedLabel, ?, ?> xoSession) {
        super(xoSession);
        this.datastoreTransaction = datastoreTransaction;
    }

    protected <T> ResultIterable<T> find(EmbeddedLabel label, PropertyMetadata datastoreMetadata, Object datastoreValue) {
        String propertyName = datastoreMetadata.getName();
        final ResourceIterator iterator = this.datastoreTransaction.getTransaction().findNodes(label.getDelegate(), propertyName, datastoreValue);
        return this.xoSession.toResult((ResultIterator)new ResultIterator<EmbeddedNode>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public EmbeddedNode next() {
                return new EmbeddedNode(EmbeddedRepository.this.datastoreTransaction, (Node)iterator.next());
            }

            public void close() {
                iterator.close();
            }
        });
    }
}

