/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.embedded.impl.model;

import com.buschmais.xo.neo4j.embedded.impl.datastore.EmbeddedDatastoreTransaction;
import com.buschmais.xo.neo4j.embedded.impl.model.EmbeddedNeo4jPropertyContainer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Entity;

public abstract class AbstractEmbeddedPropertyContainer<T extends Entity>
implements EmbeddedNeo4jPropertyContainer {
    protected final EmbeddedDatastoreTransaction transaction;
    protected final long id;

    public AbstractEmbeddedPropertyContainer(EmbeddedDatastoreTransaction transaction, Entity entity) {
        this.transaction = transaction;
        this.id = entity.getId();
    }

    public long getId() {
        return this.id;
    }

    public abstract T getDelegate();

    public boolean hasProperty(String key) {
        return this.getDelegate().hasProperty(key);
    }

    public Object getProperty(String key) {
        return this.getDelegate().getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getDelegate().setProperty(key, value);
    }

    @Override
    public Object removeProperty(String key) {
        return this.getDelegate().removeProperty(key);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : this.getDelegate().getPropertyKeys()) {
            properties.put(key, this.getProperty(key));
        }
        return properties;
    }

    public void flush() {
    }

    public void clear() {
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEmbeddedPropertyContainer)) {
            return false;
        }
        AbstractEmbeddedPropertyContainer that = (AbstractEmbeddedPropertyContainer)o;
        return this.id == that.id;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    public final String toString() {
        return this.getDelegate().toString();
    }
}

