/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oauth2.AuthenticationBuilder;
import com.c4_soft.springaddons.security.oauth2.oidc.OidcAuthentication;
import com.c4_soft.springaddons.security.oauth2.test.Defaults;
import com.c4_soft.springaddons.security.oauth2.test.OidcTokenBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class OidcAuthenticationTestingBuilder<T extends OidcAuthenticationTestingBuilder<T>>
implements AuthenticationBuilder<OidcAuthentication> {
    protected final OidcTokenBuilder tokenBuilder = new OidcTokenBuilder().subject("user").name("user");
    private final Set<String> authorities = new HashSet<String>(Arrays.asList(Defaults.AUTHORITIES));

    public OidcAuthentication build() {
        return new OidcAuthentication(this.tokenBuilder.build(), (Collection)this.authorities.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
    }

    public T authorities(String ... authorities) {
        this.authorities.clear();
        this.authorities.addAll(Arrays.asList(authorities));
        return this.downcast();
    }

    public T token(Consumer<OidcTokenBuilder> tokenBuilderConsumer) {
        tokenBuilderConsumer.accept(this.tokenBuilder);
        return this.downcast();
    }

    protected T downcast() {
        return (T)this;
    }
}

