/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.OidcTokenBuilder;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface OpenIdAddress {
    public String formattedAddress() default "";

    public String streetAddress() default "";

    public String locality() default "";

    public String region() default "";

    public String postalCode() default "";

    public String country() default "";

    public static class Claim {
        public static OidcTokenBuilder.AddressClaim of(OpenIdAddress addressAnnotation) {
            return new OidcTokenBuilder.AddressClaim().country(Claim.nullIfEmpty(addressAnnotation.country())).formatted(Claim.nullIfEmpty(addressAnnotation.formattedAddress())).locality(Claim.nullIfEmpty(addressAnnotation.locality())).postalCode(Claim.nullIfEmpty(addressAnnotation.postalCode())).region(Claim.nullIfEmpty(addressAnnotation.region())).streetAddress(Claim.nullIfEmpty(addressAnnotation.streetAddress()));
        }

        private static String nullIfEmpty(String str) {
            return StringUtils.hasText((String)str) ? str : null;
        }
    }
}

