/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.javatime;

import com.google.ical.compat.javatime.TimeZoneConverter;
import com.google.ical.compat.javatime.ZonedDateTimeIterable;
import com.google.ical.compat.javatime.ZonedDateTimeIterator;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ZonedDateTimeIteratorFactory {
    public static ZonedDateTimeIterator createDateTimeIterator(String rdata, ZonedDateTime start, ZoneId tzid, boolean strict) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(rdata, ZonedDateTimeIteratorFactory.zonedDateTimeToDateValue(start.withZoneSameInstant(tzid)), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static ZonedDateTimeIterable createDateTimeIterable(String rdata, ZonedDateTime start, ZoneId tzid, boolean strict) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(rdata, ZonedDateTimeIteratorFactory.zonedDateTimeToDateValue(start.withZoneSameInstant(tzid)), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static ZonedDateTimeIterator createDateTimeIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    static ZonedDateTime dateValueToDateTime(DateValue dvUtc) {
        if (dvUtc instanceof TimeValue) {
            TimeValue tvUtc = (TimeValue)((Object)dvUtc);
            return ZonedDateTime.of(dvUtc.year(), dvUtc.month(), dvUtc.day(), tvUtc.hour(), tvUtc.minute(), tvUtc.second(), 0, ZoneId.of("UTC"));
        }
        return ZonedDateTime.of(dvUtc.year(), dvUtc.month(), dvUtc.day(), 0, 0, 0, 0, ZoneId.of("UTC"));
    }

    static DateValue zonedDateTimeToDateValue(ZonedDateTime dt) {
        return new DateTimeValueImpl(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute(), dt.getSecond());
    }

    private ZonedDateTimeIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements ZonedDateTimeIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ZonedDateTime next() {
            return ZonedDateTimeIteratorFactory.dateValueToDateTime(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(ZonedDateTime d) {
            ZonedDateTime dUtc = d.withZoneSameInstant(ZoneId.of("UTC"));
            this.it.advanceTo(ZonedDateTimeIteratorFactory.zonedDateTimeToDateValue(dUtc));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements ZonedDateTimeIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        @Override
        public ZonedDateTimeIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

