/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.jodatime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

final class TimeZoneConverter {
    static final int MILLISECONDS_PER_SECOND = 1000;
    static final int MILLISECONDS_PER_MINUTE = 60000;
    static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final Pattern HOUR_MINUTE = Pattern.compile("^[+-]?[0-9]{1,2}:[0-9]{2}(:[0-9]{2})?$");
    private static final TimeZone UTC = new SimpleTimeZone(0, "UTC");
    private static final long MILLIS_SINCE_1_JAN_2000_UTC;

    public static TimeZone toTimeZone(final DateTimeZone dtz) {
        TimeZone tz = new TimeZone(){
            private static final long serialVersionUID = 58752546800455L;

            @Override
            public void setRawOffset(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean useDaylightTime() {
                long firstTransition = MILLIS_SINCE_1_JAN_2000_UTC;
                return firstTransition != dtz.nextTransition(firstTransition);
            }

            @Override
            public boolean inDaylightTime(Date d) {
                long t = d.getTime();
                return dtz.getStandardOffset(t) != dtz.getOffset(t);
            }

            @Override
            public int getRawOffset() {
                return dtz.getStandardOffset(0L);
            }

            @Override
            public int getOffset(long instant) {
                return dtz.getOffset(instant);
            }

            @Override
            public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
                int millis = milliseconds;
                int hour = millis / 3600000;
                int minute = (millis %= 3600000) / 60000;
                int second = (millis %= 60000) / 1000;
                millis %= 1000;
                if (era == 0) {
                    year = -(year - 1);
                }
                DateTime dt = null;
                try {
                    dt = new DateTime(year, month + 1, day, hour, minute, second, millis, dtz);
                }
                catch (IllegalArgumentException ex) {
                    if (hour < 23) {
                        dt = new DateTime(year, month + 1, day, hour + 1, minute, second, millis, dtz);
                    }
                    GregorianCalendar c = new GregorianCalendar();
                    c.clear();
                    ((Calendar)c).setTimeZone(TimeZone.getTimeZone("UTC"));
                    c.set(year, month, day, hour, minute, second);
                    ((Calendar)c).add(11, 1);
                    int year2 = c.get(1);
                    int month2 = c.get(2);
                    int day2 = c.get(5);
                    int hour2 = c.get(11);
                    dt = new DateTime(year2, month2 + 1, day2, hour2, minute, second, millis, dtz);
                }
                int offset = dtz.getStandardOffset(dt.getMillis());
                DateTime stdDt = new DateTime(year, month + 1, day, hour, minute, second, millis, DateTimeZone.forOffsetMillis((int)offset));
                return this.getOffset(stdDt.getMillis());
            }

            public String toString() {
                return dtz.toString();
            }

            public boolean equals(Object that) {
                if (!(that instanceof TimeZone)) {
                    return false;
                }
                TimeZone thatTz = (TimeZone)that;
                return this.getID().equals(thatTz.getID()) && this.hasSameRules(thatTz);
            }

            public int hashCode() {
                return this.getID().hashCode();
            }
        };
        String newTzid = TimeZoneConverter.cleanUpTzid(dtz.getID());
        tz.setID(newTzid);
        return tz;
    }

    static String cleanUpTzid(String tzid) {
        Matcher m = HOUR_MINUTE.matcher(tzid);
        return m.matches() ? "GMT" + (tzid.startsWith("-") || tzid.startsWith("+") ? "" : "+") + tzid : tzid;
    }

    private TimeZoneConverter() {
    }

    static {
        GregorianCalendar c = new GregorianCalendar(UTC);
        c.set(2000, 0, 1, 0, 0, 0);
        MILLIS_SINCE_1_JAN_2000_UTC = c.getTimeInMillis();
    }
}

