/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.CompoundIteratorImpl;
import com.google.ical.iter.Conditions;
import com.google.ical.iter.Filters;
import com.google.ical.iter.Generator;
import com.google.ical.iter.Generators;
import com.google.ical.iter.InstanceGenerators;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.RDateIteratorImpl;
import com.google.ical.iter.RRuleIteratorImpl;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.iter.Util;
import com.google.ical.util.Predicate;
import com.google.ical.util.Predicates;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.Frequency;
import com.google.ical.values.IcalObject;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class RecurrenceIteratorFactory {
    private static final Logger LOGGER = Logger.getLogger(RecurrenceIteratorFactory.class.getName());
    private static final Pattern FOLD = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
    private static final Pattern NEWLINE = Pattern.compile("[\\r\\n]+");
    private static final Pattern RULE = Pattern.compile("^(?:R|EX)RULE[:;]", 2);
    private static final Pattern DATE = Pattern.compile("^(?:R|EX)DATE[:;]", 2);
    private static final int[] NO_INTS = new int[0];
    private static final WeekdayNum[] NO_DAYS = new WeekdayNum[0];

    public static RecurrenceIterator createRecurrenceIterator(String rdata, DateValue dtStart, TimeZone tzid, boolean strict) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterable(rdata, dtStart, tzid, strict).iterator();
    }

    public static RecurrenceIterable createRecurrenceIterable(String rdata, final DateValue dtStart, final TimeZone tzid, final boolean strict) throws ParseException {
        final IcalObject[] contentLines = RecurrenceIteratorFactory.parseContentLines(rdata, tzid, strict);
        return new RecurrenceIterable(){

            @Override
            public RecurrenceIterator iterator() {
                ArrayList<RecurrenceIterator> inclusions = new ArrayList<RecurrenceIterator>();
                ArrayList<RecurrenceIterator> exclusions = new ArrayList<RecurrenceIterator>();
                inclusions.add(new RDateIteratorImpl(new DateValue[]{TimeUtils.toUtc(dtStart, tzid)}));
                for (IcalObject contentLine : contentLines) {
                    try {
                        String name = contentLine.getName();
                        if ("rrule".equalsIgnoreCase(name)) {
                            inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)contentLine, dtStart, tzid));
                            continue;
                        }
                        if ("rdate".equalsIgnoreCase(name)) {
                            inclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)contentLine));
                            continue;
                        }
                        if ("exrule".equalsIgnoreCase(name)) {
                            exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RRule)contentLine, dtStart, tzid));
                            continue;
                        }
                        if (!"exdate".equalsIgnoreCase(name)) continue;
                        exclusions.add(RecurrenceIteratorFactory.createRecurrenceIterator((RDateList)contentLine));
                    }
                    catch (IllegalArgumentException ex) {
                        if (strict) {
                            throw ex;
                        }
                        LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + contentLine.toIcal(), ex);
                    }
                }
                return new CompoundIteratorImpl(inclusions, exclusions);
            }
        };
    }

    public static RecurrenceIterator createRecurrenceIterator(String rdata, DateValue dtStart, TimeZone tzid) throws ParseException {
        return RecurrenceIteratorFactory.createRecurrenceIterator(rdata, dtStart, tzid, true);
    }

    public static RecurrenceIterator createRecurrenceIterator(RDateList rdates) {
        Object[] dates = rdates.getDatesUtc();
        Arrays.sort(dates);
        int k = 0;
        for (int i = 1; i < dates.length; ++i) {
            if (dates[i].equals(dates[k])) continue;
            dates[++k] = dates[i];
        }
        if (++k < dates.length) {
            DateValue[] uniqueDates = new DateValue[k];
            System.arraycopy(dates, 0, uniqueDates, 0, k);
            dates = uniqueDates;
        }
        return new RDateIteratorImpl((DateValue[])dates);
    }

    public static RecurrenceIterator createRecurrenceIterator(RRule rrule, DateValue dtStart, TimeZone tzid) {
        Predicate filter;
        Predicate<DateValue> condition;
        assert (null != tzid);
        assert (null != dtStart);
        Frequency freq = rrule.getFreq();
        Weekday wkst = rrule.getWkSt();
        DateValue untilUtc = rrule.getUntil();
        int count = rrule.getCount();
        int interval = rrule.getInterval();
        WeekdayNum[] byDay = rrule.getByDay().toArray(new WeekdayNum[0]);
        int[] byMonth = rrule.getByMonth();
        int[] byMonthDay = rrule.getByMonthDay();
        int[] byWeekNo = rrule.getByWeekNo();
        int[] byYearDay = rrule.getByYearDay();
        int[] bySetPos = rrule.getBySetPos();
        int[] byHour = rrule.getByHour();
        int[] byMinute = rrule.getByMinute();
        int[] bySecond = rrule.getBySecond();
        if (interval <= 0) {
            interval = 1;
        }
        if (null == wkst) {
            wkst = Weekday.MO;
        }
        if (bySetPos.length != 0) {
            switch (freq) {
                case HOURLY: {
                    if (byHour.length != 0 && byMinute.length <= 1 && bySecond.length <= 1) {
                        byHour = RecurrenceIteratorFactory.filterBySetPos(byHour, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
                case MINUTELY: {
                    if (byMinute.length != 0 && bySecond.length <= 1) {
                        byMinute = RecurrenceIteratorFactory.filterBySetPos(byMinute, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
                case SECONDLY: {
                    if (bySecond.length != 0) {
                        bySecond = RecurrenceIteratorFactory.filterBySetPos(bySecond, bySetPos);
                    }
                    bySetPos = NO_INTS;
                    break;
                }
            }
        }
        DateValue start = dtStart;
        if (bySetPos.length != 0) {
            switch (freq) {
                case YEARLY: {
                    start = dtStart instanceof TimeValue ? new DateTimeValueImpl(start.year(), 1, 1, 0, 0, 0) : new DateValueImpl(start.year(), 1, 1);
                    break;
                }
                case MONTHLY: {
                    start = dtStart instanceof TimeValue ? new DateTimeValueImpl(start.year(), start.month(), 1, 0, 0, 0) : new DateValueImpl(start.year(), start.month(), 1);
                    break;
                }
                case WEEKLY: {
                    int d = (7 + wkst.ordinal() - Weekday.valueOf(dtStart).ordinal()) % 7;
                    start = TimeUtils.add(dtStart, new DateValueImpl(0, 0, -d));
                    break;
                }
            }
        }
        ThrottledGenerator yearGenerator = Generators.serialYearGenerator(freq == Frequency.YEARLY ? interval : 1, dtStart);
        Generator monthGenerator = null;
        Generator dayGenerator = null;
        Generator secondGenerator = null;
        Generator minuteGenerator = null;
        Generator hourGenerator = null;
        ArrayList filters = new ArrayList();
        switch (freq) {
            case SECONDLY: {
                if (bySecond.length != 0 && interval == 1) break;
                secondGenerator = Generators.serialSecondGenerator(interval, dtStart);
                if (bySecond.length == 0) break;
                filters.add(Filters.bySecondFilter(bySecond));
                break;
            }
            case MINUTELY: {
                if (byMinute.length != 0 && interval == 1) break;
                minuteGenerator = Generators.serialMinuteGenerator(interval, dtStart);
                if (byMinute.length == 0) break;
                filters.add(Filters.byMinuteFilter(byMinute));
                break;
            }
            case HOURLY: {
                if (byHour.length != 0 && interval == 1) break;
                hourGenerator = Generators.serialHourGenerator(interval, dtStart);
                if (byHour.length == 0) break;
                filters.add(Filters.byHourFilter(bySecond));
                break;
            }
            case DAILY: {
                break;
            }
            case WEEKLY: {
                if (0 != byDay.length) {
                    dayGenerator = Generators.byDayGenerator(byDay, false, start);
                    byDay = NO_DAYS;
                    if (interval <= 1) break;
                    filters.add(Filters.weekIntervalFilter(interval, wkst, dtStart));
                    break;
                }
                dayGenerator = Generators.serialDayGenerator(interval * 7, dtStart);
                break;
            }
            case YEARLY: {
                if (0 != byYearDay.length) {
                    dayGenerator = Generators.byYearDayGenerator(byYearDay, start);
                    break;
                }
            }
            case MONTHLY: {
                if (0 != byMonthDay.length) {
                    dayGenerator = Generators.byMonthDayGenerator(byMonthDay, start);
                    byMonthDay = NO_INTS;
                    break;
                }
                if (0 != byWeekNo.length && Frequency.YEARLY == freq) {
                    dayGenerator = Generators.byWeekNoGenerator(byWeekNo, wkst, start);
                    byWeekNo = NO_INTS;
                    break;
                }
                if (0 != byDay.length) {
                    dayGenerator = Generators.byDayGenerator(byDay, Frequency.YEARLY == freq && 0 == byMonth.length, start);
                    byDay = NO_DAYS;
                    break;
                }
                if (Frequency.YEARLY == freq) {
                    monthGenerator = Generators.byMonthGenerator(new int[]{dtStart.month()}, start);
                }
                dayGenerator = Generators.byMonthDayGenerator(new int[]{dtStart.day()}, start);
            }
        }
        if (secondGenerator == null) {
            secondGenerator = Generators.bySecondGenerator(bySecond, start);
        }
        if (minuteGenerator == null) {
            minuteGenerator = byMinute.length == 0 && freq.compareTo(Frequency.MINUTELY) < 0 ? Generators.serialMinuteGenerator(1, dtStart) : Generators.byMinuteGenerator(byMinute, start);
        }
        if (hourGenerator == null) {
            hourGenerator = byHour.length == 0 && freq.compareTo(Frequency.HOURLY) < 0 ? Generators.serialHourGenerator(1, dtStart) : Generators.byHourGenerator(byHour, start);
        }
        if (dayGenerator == null) {
            boolean dailyOrMoreOften;
            boolean bl = dailyOrMoreOften = freq.compareTo(Frequency.DAILY) <= 0;
            if (byMonthDay.length != 0) {
                dayGenerator = Generators.byMonthDayGenerator(byMonthDay, start);
                byMonthDay = NO_INTS;
            } else if (byDay.length != 0) {
                dayGenerator = Generators.byDayGenerator(byDay, Frequency.YEARLY == freq, start);
                byDay = NO_DAYS;
            } else {
                dayGenerator = dailyOrMoreOften ? Generators.serialDayGenerator(Frequency.DAILY == freq ? interval : 1, dtStart) : Generators.byMonthDayGenerator(new int[]{dtStart.day()}, start);
            }
        }
        if (0 != byDay.length) {
            filters.add(Filters.byDayFilter(byDay, Frequency.YEARLY == freq, wkst));
            byDay = NO_DAYS;
        }
        if (0 != byMonthDay.length) {
            filters.add(Filters.byMonthDayFilter(byMonthDay));
        }
        if (0 != byMonth.length) {
            monthGenerator = Generators.byMonthGenerator(byMonth, start);
        } else if (null == monthGenerator) {
            monthGenerator = Generators.serialMonthGenerator(freq == Frequency.MONTHLY ? interval : 1, dtStart);
        }
        boolean canShortcutAdvance = true;
        if (0 != count) {
            condition = Conditions.countCondition(count);
            canShortcutAdvance = false;
        } else if (null != untilUtc) {
            if (untilUtc instanceof TimeValue != dtStart instanceof TimeValue) {
                untilUtc = dtStart instanceof TimeValue ? TimeUtils.dayStart(untilUtc) : TimeUtils.toDateValue(untilUtc);
            }
            condition = Conditions.untilCondition(untilUtc);
        } else {
            condition = Predicates.alwaysTrue();
        }
        switch (filters.size()) {
            case 0: {
                filter = Predicates.alwaysTrue();
                break;
            }
            case 1: {
                filter = (Predicate)filters.get(0);
                break;
            }
            default: {
                filter = Predicates.and(filters);
            }
        }
        Generator instanceGenerator = null;
        instanceGenerator = 0 != bySetPos.length ? InstanceGenerators.bySetPosInstanceGenerator(bySetPos, freq, wkst, filter, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator) : InstanceGenerators.serialInstanceGenerator(filter, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator);
        return new RRuleIteratorImpl(dtStart, tzid, condition, instanceGenerator, yearGenerator, monthGenerator, dayGenerator, hourGenerator, minuteGenerator, secondGenerator, canShortcutAdvance);
    }

    public static RecurrenceIterator join(RecurrenceIterator a, RecurrenceIterator ... b) {
        ArrayList<RecurrenceIterator> incl = new ArrayList<RecurrenceIterator>();
        incl.add(a);
        incl.addAll(Arrays.asList(b));
        return new CompoundIteratorImpl(incl, Collections.emptyList());
    }

    public static RecurrenceIterator except(RecurrenceIterator included, RecurrenceIterator excluded) {
        return new CompoundIteratorImpl(Collections.singleton(included), Collections.singleton(excluded));
    }

    private static IcalObject[] parseContentLines(String rdata, TimeZone tzid, boolean strict) throws ParseException {
        String unfolded = FOLD.matcher(rdata).replaceAll("").trim();
        if ("".equals(unfolded)) {
            return new IcalObject[0];
        }
        String[] lines = NEWLINE.split(unfolded);
        IcalObject[] out = new IcalObject[lines.length];
        int nbad = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            try {
                if (RULE.matcher(line).find()) {
                    out[i] = new RRule(line);
                    continue;
                }
                if (DATE.matcher(line).find()) {
                    out[i] = new RDateList(line, tzid);
                    continue;
                }
                throw new ParseException(lines[i], i);
            }
            catch (ParseException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + line, ex);
                ++nbad;
                continue;
            }
            catch (IllegalArgumentException ex) {
                if (strict) {
                    throw ex;
                }
                LOGGER.log(Level.SEVERE, "Dropping bad recurrence rule line: " + line, ex);
                ++nbad;
            }
        }
        if (0 != nbad) {
            IcalObject[] trimmed = new IcalObject[out.length - nbad];
            int i = 0;
            int k = 0;
            while (i < trimmed.length) {
                if (null != out[k]) {
                    trimmed[i++] = out[k];
                }
                ++k;
            }
            out = trimmed;
        }
        return out;
    }

    private static int[] filterBySetPos(int[] members, int[] bySetPos) {
        members = Util.uniquify(members);
        IntSet iset = new IntSet();
        for (int pos : bySetPos) {
            if (pos == 0) continue;
            pos = pos < 0 ? (pos += members.length) : --pos;
            if (pos < 0 || pos >= members.length) continue;
            iset.add(members[pos]);
        }
        return iset.toIntArray();
    }

    private RecurrenceIteratorFactory() {
    }
}

