/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.maven.flatten;

import com.carrotgarden.maven.flatten.Context;
import com.carrotgarden.maven.flatten.Support;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="flatten", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true)
public class FlattenMojo
extends AbstractMojo
implements Context {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    MavenSession mavenSession;
    @Component
    BuildPluginManager buildManager;
    @Component
    BuildContext buildContext;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    PluginDescriptor pluginMeta;
    @Parameter(property="flatten.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="flatten.resolveExclusions", defaultValue="true")
    boolean resolveExclusions;
    @Parameter(property="flatten.memberRemoveList")
    String[] memberRemoveList = new String[0];
    @Parameter(property="flatten.scopeEraseList", defaultValue="test")
    String[] scopeEraseList = new String[0];
    @Parameter(property="flatten.packagingSwitchList", defaultValue="jar,war,ear,bundle,maven-plugin")
    String[] packagingSwitchList = new String[0];
    @Parameter(property="flatten.targetPomFile", defaultValue="${project.build.directory}/flatten/pom.xml.flatten")
    File targetPomFile;
    @Parameter(property="flatten.performDependencyResolve", defaultValue="true")
    boolean performDependencyResolve;
    @Parameter(property="flatten.performEraseScopes", defaultValue="false")
    boolean performEraseScopes;
    @Parameter(property="flatten.performRemoveMembers", defaultValue="true")
    boolean performRemoveMembers;
    @Parameter(property="flatten.performOverrideIdentity", defaultValue="false")
    boolean performOverrideIdentity;
    @Parameter(property="flatten.performSwitchPomXml", defaultValue="true")
    boolean performSwitchPomXml;
    @Parameter(property="flatten.encoding", defaultValue="UTF-8")
    String encoding;
    @Parameter(property="flatten.overrideGroupId", defaultValue="${project.groupId}")
    String overrideGroupId;
    @Parameter(property="flatten.overrideArtifactId", defaultValue="${project.artifactId}")
    String overrideArtifactId;

    Charset modelCharset(Model model) {
        String encoding = model.getModelEncoding();
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = this.encoding;
        }
        return Charset.forName(encoding);
    }

    boolean hasPackagingSwitch() {
        for (String packaging : this.packagingSwitchList) {
            if (!packaging.equals(this.project.getPackaging())) continue;
            return true;
        }
        return false;
    }

    void executeSelfMojo(String goal) throws Exception {
        Support.executePluginMojo(this.pluginMeta, this.buildManager, this.mavenSession, goal);
    }

    void resolveReplaceDependency(Model baseModel, Model flatModel) throws Exception {
        Set resolvedArtifactList = this.contextResolvedExtract();
        List baseDependencyList = baseModel.getDependencies();
        ArrayList<Dependency> flatDependencyList = new ArrayList<Dependency>();
        for (Artifact resolvedArtifact : resolvedArtifactList) {
            Dependency flatDependency = new Dependency();
            Support.resolveApplyDeclared(resolvedArtifact, flatDependency);
            boolean hasSystem = "system".equals(resolvedArtifact.getScope());
            if (hasSystem) {
                Dependency baseDependency = Support.resolveLocateMatching(baseDependencyList, resolvedArtifact);
                if (baseDependency == null) {
                    String artifactKey = ArtifactUtils.key((Artifact)resolvedArtifact);
                    this.getLog().warn((CharSequence)("no matching artifact: " + artifactKey));
                } else {
                    flatDependency.setSystemPath(baseDependency.getSystemPath());
                }
            }
            if (this.resolveExclusions) {
                Support.resolveApplyExclusions(baseModel, resolvedArtifact, flatDependency);
            }
            flatDependencyList.add(flatDependency);
        }
        flatModel.setDependencies(flatDependencyList);
    }

    void eraseScopes(Model model) throws Exception {
        for (String scope : this.scopeEraseList) {
            Support.removeScope(model, scope);
        }
    }

    void removeMembers(Model model) throws Exception {
        for (String member : this.memberRemoveList) {
            Support.removeMember(model, member);
        }
    }

    void persistModel(Model model) throws Exception {
        File file = this.targetPomFile;
        Charset charset = this.modelCharset(model);
        Support.ensureParent(file);
        Support.modelWrite(model, file, charset);
        this.buildContext.refresh(file);
    }

    void overrideIdentity(Model model) {
        model.setGroupId(this.overrideGroupId);
        model.setArtifactId(this.overrideArtifactId);
    }

    void overrideIdentity(Artifact artifact) {
        artifact.setGroupId(this.overrideGroupId);
        artifact.setArtifactId(this.overrideArtifactId);
    }

    void overrideIdentity(Build build) {
        String finalName = this.overrideArtifactId + "-" + this.project.getVersion();
        build.setFinalName(finalName);
    }

    void overrideIdentity(MavenProject project) {
        this.overrideIdentity(project.getModel());
        this.overrideIdentity(project.getArtifact());
        this.overrideIdentity(project.getBuild());
    }

    void switchProjectPomXml() throws Exception {
        File file = this.targetPomFile;
        this.project.setPomFile(file);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext.isIncremental()) {
            this.getLog().info((CharSequence)"Skipping incremental execution.");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin goal execution.");
            return;
        }
        File sourcePomFile = this.project.getModel().getPomFile();
        try {
            Model baseModel = Support.modelRead(sourcePomFile, this.modelCharset(this.project.getModel()));
            Model flatModel = this.project.getModel().clone();
            this.buildContext.removeMessages(sourcePomFile);
            if (this.performDependencyResolve) {
                this.getLog().info((CharSequence)"Resolving dependencies.");
                this.executeSelfMojo("resolve");
                this.resolveReplaceDependency(baseModel, flatModel);
            }
            if (this.performEraseScopes) {
                this.getLog().info((CharSequence)"Erasing dependency scopes.");
                this.eraseScopes(flatModel);
            }
            if (this.performRemoveMembers) {
                this.getLog().info((CharSequence)"Removing pom.xml model members.");
                this.removeMembers(flatModel);
            }
            if (this.performOverrideIdentity) {
                this.getLog().info((CharSequence)"Overriding project maven identity.");
                this.overrideIdentity(flatModel);
                this.overrideIdentity(this.project);
            }
            this.persistModel(flatModel);
            if (this.performSwitchPomXml && this.hasPackagingSwitch()) {
                this.getLog().info((CharSequence)"Switching project to flattened pom.xml.");
                this.switchProjectPomXml();
            }
        }
        catch (Throwable e) {
            String message = "Flatten failure";
            this.buildContext.addMessage(sourcePomFile, 1, 1, message, 2, e);
            throw new MojoFailureException(message, e);
        }
    }
}

