/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.maven.flatten;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class Support {
    public static String capitalFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static void ensureParent(File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void executePluginMojo(PluginDescriptor pluginMeta, BuildPluginManager buildManager, MavenSession mavenSession, String goal) throws Exception {
        MojoDescriptor mojoMeta = pluginMeta.getMojo(goal);
        Xpp3Dom pluginConfig = (Xpp3Dom)pluginMeta.getPlugin().getConfiguration();
        Xpp3Dom executionConfig = Support.toXpp3Dom(mojoMeta.getMojoConfiguration());
        Xpp3Dom[] executionEntryList = executionConfig.getChildren();
        if (pluginConfig != null && executionEntryList != null) {
            for (Xpp3Dom entry : executionEntryList) {
                Xpp3Dom pluginEntry = pluginConfig.getChild(entry.getName());
                if (pluginEntry == null) continue;
                executionConfig.addChild(pluginEntry);
            }
        }
        MojoExecution mojoExecution = new MojoExecution(mojoMeta, executionConfig);
        buildManager.executeMojo(mavenSession, mojoExecution);
    }

    public static Method findMethod(Model model, String name, int count) throws Exception {
        Method[] methodList;
        for (Method method : methodList = model.getClass().getMethods()) {
            boolean hasCount;
            boolean hasName = name.equals(method.getName());
            boolean bl = hasCount = count == method.getParameterCount();
            if (!hasName || !hasCount) continue;
            return method;
        }
        throw new RuntimeException("Method not found: " + name);
    }

    public static <T> void privateFieldSet(Class<T> klaz, T inst, String fieldName, Object fieldValue) throws Exception {
        Field field = klaz.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(inst, fieldValue);
    }

    public static void removeMember(Model model, String name) throws Exception {
        String setter = "set" + Support.capitalFirst(name);
        Method method = Support.findMethod(model, setter, 1);
        method.invoke((Object)model, new Object[]{null});
    }

    public static void removeScope(Model model, String scope) {
        List source = model.getDependencies();
        if (source == null || source.isEmpty()) {
            return;
        }
        ArrayList<Dependency> target = new ArrayList<Dependency>();
        for (Dependency dep : source) {
            String depScope = dep.getScope();
            if (!StringUtils.isEmpty((String)depScope) && depScope.equals(scope)) continue;
            target.add(dep);
        }
        model.setDependencies(target);
    }

    public static void resolveApplyDeclared(Artifact artifact, Dependency dependency) {
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setType(artifact.getType());
        dependency.setScope(artifact.getScope());
        dependency.setClassifier(artifact.getClassifier());
        dependency.setOptional(artifact.isOptional());
    }

    public static void resolveApplyExclusions(List<Dependency> depenendencyList, Artifact artifact, Dependency dependency) {
        String optional;
        Dependency matching = Support.resolveLocateMatching(depenendencyList, artifact);
        if (matching == null) {
            return;
        }
        List exclusions = matching.getExclusions();
        if (exclusions != null && !exclusions.isEmpty()) {
            dependency.setExclusions(matching.getExclusions());
        }
        if ((optional = matching.getOptional()) != null) {
            dependency.setOptional(matching.getOptional());
        }
    }

    public static void resolveApplyExclusions(Model model, Artifact artifact, Dependency dependency) {
        DependencyManagement management = model.getDependencyManagement();
        if (management != null && management.getDependencies() != null) {
            Support.resolveApplyExclusions(management.getDependencies(), artifact, dependency);
        }
        if (model.getDependencies() != null) {
            Support.resolveApplyExclusions(model.getDependencies(), artifact, dependency);
        }
    }

    public static Dependency resolveLocateMatching(List<Dependency> depenendencyList, Artifact artifact) {
        if (depenendencyList == null || artifact == null) {
            return null;
        }
        for (Dependency dependency : depenendencyList) {
            boolean hasType = org.apache.commons.lang3.StringUtils.equals((CharSequence)dependency.getType(), (CharSequence)artifact.getType());
            boolean hasGroup = org.apache.commons.lang3.StringUtils.equals((CharSequence)dependency.getGroupId(), (CharSequence)artifact.getGroupId());
            boolean hasArtifact = org.apache.commons.lang3.StringUtils.equals((CharSequence)dependency.getArtifactId(), (CharSequence)artifact.getArtifactId());
            boolean hasClassifier = org.apache.commons.lang3.StringUtils.equals((CharSequence)dependency.getClassifier(), (CharSequence)artifact.getClassifier());
            if (!hasType || !hasGroup || !hasArtifact || !hasClassifier) continue;
            return dependency;
        }
        return null;
    }

    public static Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(Support.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }

    public static Model modelRead(File pomFile, Charset charset) throws Exception {
        List<String> pomLines = Files.readAllLines(pomFile.toPath(), charset);
        String pomText = org.apache.commons.lang3.StringUtils.join(pomLines, (String)"\n");
        StringReader textReader = new StringReader(pomText);
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model pomModel = pomReader.read((Reader)textReader);
        return pomModel;
    }

    public static void modelWrite(Model pomModel, File pomFile, Charset charset) throws Exception {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter textWriter = new StringWriter(65536);
        pomWriter.write((Writer)textWriter, pomModel);
        String pomText = textWriter.toString();
        Files.write(pomFile.toPath(), pomText.getBytes(charset), new OpenOption[0]);
    }
}

