/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.ClassGlobFilter;
import com.carrotsearch.randomizedtesting.ClassModel;
import com.carrotsearch.randomizedtesting.Classes;
import com.carrotsearch.randomizedtesting.CloseableResourceInfo;
import com.carrotsearch.randomizedtesting.GroupEvaluator;
import com.carrotsearch.randomizedtesting.InstanceProvider;
import com.carrotsearch.randomizedtesting.JUnit4MethodProvider;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.randomizedtesting.MurmurHash3;
import com.carrotsearch.randomizedtesting.ObjectProcedure;
import com.carrotsearch.randomizedtesting.RandomSupplier;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.randomizedtesting.ResourceDisposalError;
import com.carrotsearch.randomizedtesting.Rethrow;
import com.carrotsearch.randomizedtesting.RunnerContainer;
import com.carrotsearch.randomizedtesting.RunnerThreadGroup;
import com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.TestMethodAndParams;
import com.carrotsearch.randomizedtesting.TestMethodProvider;
import com.carrotsearch.randomizedtesting.ThreadLeakControl;
import com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.randomizedtesting.TraceFormatting;
import com.carrotsearch.randomizedtesting.Validation;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.Name;
import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.carrotsearch.randomizedtesting.annotations.Seed;
import com.carrotsearch.randomizedtesting.annotations.SeedDecorators;
import com.carrotsearch.randomizedtesting.annotations.Seeds;
import com.carrotsearch.randomizedtesting.annotations.TestCaseInstanceProvider;
import com.carrotsearch.randomizedtesting.annotations.TestCaseOrdering;
import com.carrotsearch.randomizedtesting.annotations.TestContextRandomSupplier;
import com.carrotsearch.randomizedtesting.annotations.TestMethodProviders;
import com.carrotsearch.randomizedtesting.annotations.Timeout;
import com.carrotsearch.randomizedtesting.rules.StatementAdapter;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public final class RandomizedRunner
extends Runner
implements Filterable {
    public static final String AUGMENTED_SEED_PACKAGE = "__randomizedtesting";
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT_SUITE = 0;
    public static final int DEFAULT_KILLATTEMPTS = 5;
    public static final int DEFAULT_KILLWAIT = 500;
    public static final int DEFAULT_ITERATIONS = 1;
    static final Logger logger = Logger.getLogger(RandomizedRunner.class.getSimpleName());
    private static final AtomicLong sequencer = new AtomicLong();
    private static final List<String> DEFAULT_STACK_FILTERS = Arrays.asList("org.junit.", "junit.framework.", "sun.", "java.lang.reflect.", "com.carrotsearch.randomizedtesting.");
    private final Class<?> suiteClass;
    final Randomness runnerRandomness;
    private Randomness testCaseRandomnessOverride;
    private final Integer iterationsOverride;
    private List<TestCandidate> testCandidates;
    private Description suiteDescription;
    RunnerThreadGroup runnerThreadGroup;
    private final List<RunListener> autoListeners = new ArrayList<RunListener>();
    private boolean appendSeedParameter;
    private final TraceFormatting traces;
    private RunnerContainer containerRunner;
    QueueUncaughtExceptionsHandler handler;
    private ClassModel classModel;
    private final RandomSupplier randomSupplier;
    private Map<Class<? extends Annotation>, List<Method>> shuffledMethodsCache = new HashMap<Class<? extends Annotation>, List<Method>>();
    static AtomicBoolean zombieMarker = new AtomicBoolean(false);
    static final ThreadGroup mainThreadGroup = Thread.currentThread().getThreadGroup();
    private final Map<String, String> restoreProperties = new HashMap<String, String>();
    public GroupEvaluator groupEvaluator;

    public RandomizedRunner(Class<?> testClass) throws InitializationError {
        long initialSeed;
        this.appendSeedParameter = RandomizedTest.systemPropertyAsBoolean(SysGlobals.SYSPROP_APPEND_SEED(), false);
        this.traces = RandomizedTest.systemPropertyAsBoolean(SysGlobals.SYSPROP_STACKFILTERING(), true) ? new TraceFormatting(DEFAULT_STACK_FILTERS) : new TraceFormatting();
        this.suiteClass = testClass;
        this.classModel = new ClassModel(testClass);
        this.containerRunner = RandomizedRunner.detectContainer();
        ArrayList<SeedDecorator> decorators = new ArrayList<SeedDecorator>();
        for (SeedDecorators decAnn : RandomizedRunner.getAnnotationsFromClassHierarchy(testClass, SeedDecorators.class)) {
            for (Class<? extends SeedDecorator> clazz : decAnn.value()) {
                try {
                    SeedDecorator dec = clazz.newInstance();
                    dec.initialize(testClass);
                    decorators.add(dec);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not initialize suite class: " + testClass.getName() + " because its @SeedDecorators contains non-instantiable: " + clazz.getName(), t);
                }
            }
        }
        SeedDecorator[] decArray = decorators.toArray(new SeedDecorator[decorators.size()]);
        this.randomSupplier = this.determineRandomSupplier(testClass);
        long randomSeed = MurmurHash3.hash(sequencer.getAndIncrement() + System.nanoTime());
        String globalSeed = RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_RANDOM_SEED()));
        if (globalSeed != null) {
            long[] seedChain = SeedUtils.parseSeedChain(globalSeed);
            if (seedChain.length == 0 || seedChain.length > 2) {
                throw new IllegalArgumentException("Invalid system property " + SysGlobals.SYSPROP_RANDOM_SEED() + " specification: " + globalSeed);
            }
            if (seedChain.length > 1) {
                this.testCaseRandomnessOverride = new Randomness(seedChain[1], this.randomSupplier, new SeedDecorator[0]);
            }
            initialSeed = seedChain[0];
        } else {
            initialSeed = this.suiteClass.isAnnotationPresent(Seed.class) ? this.seedFromAnnot(this.suiteClass, randomSeed)[0] : randomSeed;
        }
        this.runnerRandomness = new Randomness(initialSeed, this.randomSupplier, decArray);
        if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_ITERATIONS())) != null) {
            this.iterationsOverride = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_ITERATIONS(), 0);
            if (this.iterationsOverride < 1) {
                throw new IllegalArgumentException("System property " + SysGlobals.SYSPROP_ITERATIONS() + " must be >= 1: " + this.iterationsOverride);
            }
        } else {
            this.iterationsOverride = null;
        }
        try {
            ClassGlobFilter suiteFilter;
            this.validateTarget();
            this.suiteDescription = Description.createSuiteDescription(this.suiteClass);
            this.testCandidates = this.collectTestCandidates(this.suiteDescription);
            this.groupEvaluator = new GroupEvaluator(this.testCandidates);
            if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD())) != null) {
                this.filter(new MethodGlobFilter(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD())));
            }
            if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTCLASS())) != null && !(suiteFilter = new ClassGlobFilter(System.getProperty(SysGlobals.SYSPROP_TESTCLASS()))).shouldRun(this.suiteDescription)) {
                this.suiteDescription.getChildren().clear();
                this.testCandidates.clear();
            }
        }
        catch (Throwable t) {
            throw new InitializationError(t);
        }
    }

    private RandomSupplier determineRandomSupplier(Class<?> testClass) {
        List<TestContextRandomSupplier> randomImpl = RandomizedRunner.getAnnotationsFromClassHierarchy(testClass, TestContextRandomSupplier.class);
        if (randomImpl.size() == 0) {
            return RandomSupplier.DEFAULT;
        }
        Class<? extends RandomSupplier> clazz = randomImpl.get(randomImpl.size() - 1).value();
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate random supplier of class: " + clazz, e);
        }
    }

    private static RunnerContainer detectContainer() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > 0) {
            String topClass = stack[stack.length - 1].getClassName();
            if (topClass.equals("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner")) {
                return RunnerContainer.ECLIPSE;
            }
            if (topClass.startsWith("com.intellij.")) {
                return RunnerContainer.IDEA;
            }
        }
        return RunnerContainer.UNKNOWN;
    }

    public Description getDescription() {
        return this.suiteDescription;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.testCandidates = RandomizedRunner.applyFilters(this.suiteClass, this.testCandidates, Collections.singleton(filter));
        Set<Description> descriptions = Collections.newSetFromMap(new IdentityHashMap());
        for (TestCandidate tc : this.testCandidates) {
            descriptions.add(tc.description);
        }
        this.suiteDescription = RandomizedRunner.prune(this.suiteDescription, descriptions);
        if (this.testCandidates.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    private static Description prune(Description suite, Set<Description> permitted) {
        if (suite.isSuite()) {
            ArrayList children = suite.getChildren();
            ArrayList<Description> retained = new ArrayList<Description>(children.size());
            for (Description child : children) {
                if (child.isSuite()) {
                    Description description = RandomizedRunner.prune(child, permitted);
                    if (child.getChildren().isEmpty()) continue;
                    retained.add(description);
                    continue;
                }
                if (!permitted.contains(child)) continue;
                retained.add(child);
            }
            Description suiteDescription = suite.childlessCopy();
            for (Description description : retained) {
                suiteDescription.addChild(description);
            }
            return suiteDescription;
        }
        return suite;
    }

    public void run(RunNotifier notifier) {
        this.processSystemProperties();
        try {
            this.runSuite(notifier);
        }
        finally {
            this.restoreSystemProperties();
        }
    }

    private void restoreSystemProperties() {
        for (Map.Entry<String, String> e : this.restoreProperties.entrySet()) {
            try {
                if (e.getValue() == null) {
                    System.clearProperty(e.getKey());
                    continue;
                }
                System.setProperty(e.getKey(), e.getValue());
            }
            catch (SecurityException x) {
                logger.warning("Could not restore system property: " + e.getKey() + " => " + e.getValue());
            }
        }
    }

    private void processSystemProperties() {
        try {
            String jvmCount = System.getProperty("junit4.childvm.count");
            String jvmId = System.getProperty("junit4.childvm.id");
            if (RandomizedRunner.emptyToNull(jvmCount) == null && RandomizedRunner.emptyToNull(jvmId) == null) {
                System.setProperty("junit4.childvm.count", "1");
                System.setProperty("junit4.childvm.id", "0");
                this.restoreProperties.put("junit4.childvm.count", jvmCount);
                this.restoreProperties.put("junit4.childvm.id", jvmId);
            }
        }
        catch (SecurityException e) {
            logger.warning("Could not set child VM count and ID properties.");
        }
    }

    private void runSuite(final RunNotifier notifier) {
        final Thread.UncaughtExceptionHandler previous = Thread.getDefaultUncaughtExceptionHandler();
        this.handler = new QueueUncaughtExceptionsHandler();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.setDefaultUncaughtExceptionHandler(RandomizedRunner.this.handler);
                return null;
            }
        });
        this.runnerThreadGroup = new RunnerThreadGroup("TGRP-" + Classes.simpleName(this.suiteClass));
        Thread runner = new Thread(this.runnerThreadGroup, "SUITE-" + Classes.simpleName(this.suiteClass) + "-seed#" + SeedUtils.formatSeedChain(this.runnerRandomness)){

            @Override
            public void run() {
                try {
                    try {
                        Class.forName(RandomizedRunner.this.suiteClass.getName(), true, RandomizedRunner.this.suiteClass.getClassLoader());
                    }
                    catch (ExceptionInInitializerError e) {
                        throw e.getCause();
                    }
                    RandomizedContext context = RandomizedRunner.this.createContext(RandomizedRunner.this.runnerThreadGroup);
                    RandomizedRunner.this.runSuite(context, notifier);
                    context.dispose();
                }
                catch (Throwable t) {
                    notifier.fireTestFailure(new Failure(RandomizedRunner.this.suiteDescription, t));
                }
            }
        };
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException e) {
            notifier.fireTestFailure(new Failure(this.suiteDescription, (Throwable)new RuntimeException("Interrupted while waiting for the suite runner? Weird.", e)));
        }
        Thread.UncaughtExceptionHandler current = Thread.getDefaultUncaughtExceptionHandler();
        if (current != this.handler) {
            notifier.fireTestFailure(new Failure(this.suiteDescription, (Throwable)new RuntimeException("Suite replaced Thread.defaultUncaughtExceptionHandler. It's better not to touch it. Or at least revert it to what it was before. Current: " + (current == null ? "(null)" : current.getClass()))));
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.setDefaultUncaughtExceptionHandler(previous);
                return null;
            }
        });
        this.runnerThreadGroup = null;
        this.handler = null;
    }

    private void runSuite(RandomizedContext context, RunNotifier notifier) {
        RunListener accounting;
        Result result;
        block14: {
            result = new Result();
            accounting = result.createListener();
            notifier.addListener(accounting);
            Randomness classRandomness = this.runnerRandomness.clone(Thread.currentThread());
            context.push(classRandomness);
            try {
                this.subscribeListeners(notifier);
                for (RunListener r : this.autoListeners) {
                    try {
                        r.testRunStarted(this.suiteDescription);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Panic: RunListener hook shouldn't throw exceptions.", e);
                    }
                }
                List<TestCandidate> tests = this.testCandidates;
                if (tests.isEmpty()) break block14;
                Map<TestCandidate, Boolean> ignored = this.determineIgnoredTests(tests);
                if (ignored.size() == tests.size()) {
                    for (TestCandidate c : tests) {
                        if (!ignored.get(c).booleanValue()) continue;
                        this.reportAsIgnored(notifier, this.groupEvaluator, c);
                    }
                    break block14;
                }
                ThreadLeakControl threadLeakControl = new ThreadLeakControl(notifier, this);
                Statement s = this.runTestsStatement(threadLeakControl.notifier(), tests, ignored, threadLeakControl);
                s = this.withClassBefores(s);
                s = this.withClassAfters(s);
                s = this.withClassRules(s);
                s = RandomizedRunner.withCloseContextResources(s, LifecycleScope.SUITE);
                s = threadLeakControl.forSuite(s, this.suiteDescription);
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    t = RandomizedRunner.augmentStackTrace(t, this.runnerRandomness);
                    if (this.isAssumptionViolated(t)) {
                        notifier.fireTestAssumptionFailed(new Failure(this.suiteDescription, t));
                        for (TestCandidate c : tests) {
                            notifier.fireTestIgnored(c.description);
                        }
                        break block14;
                    }
                    this.fireTestFailure(notifier, this.suiteDescription, t);
                }
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(this.suiteDescription, t));
            }
        }
        for (RunListener r : this.autoListeners) {
            try {
                r.testRunFinished(result);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Panic: RunListener hook shouldn't throw exceptions.", e);
            }
        }
        notifier.removeListener(accounting);
        this.unsubscribeListeners(notifier);
        context.popAndDestroy();
    }

    private Map<TestCandidate, Boolean> determineIgnoredTests(List<TestCandidate> tests) {
        IdentityHashMap<TestCandidate, Boolean> ignoredTests = new IdentityHashMap<TestCandidate, Boolean>();
        for (TestCandidate c : tests) {
            if (this.hasIgnoreAnnotation(c)) {
                ignoredTests.put(c, true);
            }
            if (!this.isTestFiltered(this.groupEvaluator, c)) continue;
            if (this.containerRunner == RunnerContainer.ECLIPSE || this.containerRunner == RunnerContainer.IDEA || !this.groupEvaluator.hasFilteringExpression()) {
                ignoredTests.put(c, true);
                continue;
            }
            ignoredTests.put(c, false);
        }
        return ignoredTests;
    }

    private static Statement withCloseContextResources(Statement s, final LifecycleScope scope) {
        return new StatementAdapter(s){

            @Override
            protected void afterAlways(final List<Throwable> errors) throws Throwable {
                ObjectProcedure<CloseableResourceInfo> disposer = new ObjectProcedure<CloseableResourceInfo>(){

                    @Override
                    public void apply(CloseableResourceInfo info) {
                        try {
                            info.getResource().close();
                        }
                        catch (Throwable t) {
                            ResourceDisposalError e = new ResourceDisposalError("Resource in scope " + info.getScope().name() + " failed to close. Resource was registered from thread " + info.getThreadName() + ", registration stack trace below.", t);
                            e.setStackTrace(info.getAllocationStack());
                            errors.add(e);
                        }
                    }
                };
                RandomizedContext.current().closeResources(disposer, scope);
            }
        };
    }

    private Statement runTestsStatement(final RunNotifier notifier, final List<TestCandidate> tests, final Map<TestCandidate, Boolean> ignored, final ThreadLeakControl threadLeakControl) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                for (TestCandidate c : tests) {
                    if (threadLeakControl.isTimedOut()) break;
                    String testThreadName = "TEST-" + Classes.simpleName(RandomizedRunner.this.suiteClass) + "." + c.method.getName() + "-seed#" + SeedUtils.formatSeedChain(RandomizedRunner.this.runnerRandomness);
                    String restoreName = Thread.currentThread().getName();
                    RandomizedContext current = RandomizedContext.current();
                    try {
                        Thread.currentThread().setName(testThreadName);
                        current.push(new Randomness(c.seed, RandomizedRunner.this.randomSupplier, new SeedDecorator[0]));
                        current.setTargetMethod(c.method);
                        if (ignored.containsKey(c)) {
                            if (!((Boolean)ignored.get(c)).booleanValue()) continue;
                            RandomizedRunner.this.reportAsIgnored(notifier, RandomizedRunner.this.groupEvaluator, c);
                            continue;
                        }
                        RandomizedRunner.this.runSingleTest(notifier, c, threadLeakControl);
                    }
                    finally {
                        Thread.currentThread().setName(restoreName);
                        current.setTargetMethod(null);
                        current.popAndDestroy();
                    }
                }
            }
        };
    }

    void reportAsIgnored(RunNotifier notifier, GroupEvaluator ge, TestCandidate c) {
        if (c.method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(c.description);
            return;
        }
        String ignoreReason = ge.getIgnoreReason(c.method, this.suiteClass);
        if (ignoreReason != null) {
            notifier.fireTestStarted(c.description);
            notifier.fireTestAssumptionFailed(new Failure(c.description, (Throwable)new AssumptionViolatedException(ignoreReason)));
            notifier.fireTestFinished(c.description);
        }
    }

    private void fireTestFailure(RunNotifier notifier, Description description, Throwable t) {
        if (t instanceof MultipleFailureException) {
            for (Throwable nested : ((MultipleFailureException)t).getFailures()) {
                this.fireTestFailure(notifier, description, nested);
            }
        } else {
            notifier.fireTestFailure(new Failure(description, t));
        }
    }

    private Statement withClassBefores(final Statement s) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    for (Method method : RandomizedRunner.this.getShuffledMethods(BeforeClass.class)) {
                        RandomizedRunner.this.invoke(method, null, new Object[0]);
                    }
                }
                catch (Throwable t) {
                    throw RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness);
                }
                s.evaluate();
            }
        };
    }

    private Statement withClassAfters(final Statement s) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    errors.add(RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness));
                }
                for (Method method : RandomizedRunner.this.getShuffledMethods(AfterClass.class)) {
                    try {
                        RandomizedRunner.this.invoke(method, null, new Object[0]);
                    }
                    catch (Throwable t) {
                        errors.add(RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness));
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private Statement withClassRules(Statement s) {
        List<TestRule> classRules = this.getAnnotatedFieldValues(null, ClassRule.class, TestRule.class);
        for (TestRule rule : classRules) {
            s = rule.apply(s, this.suiteDescription);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSingleTest(RunNotifier notifier, final TestCandidate c, ThreadLeakControl threadLeakControl) {
        notifier.fireTestStarted(c.description);
        try {
            final Object instance = c.instanceProvider.newInstance();
            Statement s = new Statement(){

                public void evaluate() throws Throwable {
                    RandomizedRunner.this.invoke(c.method, instance, new Object[0]);
                }
            };
            s = this.wrapExpectedExceptions(s, c);
            s = this.wrapBeforeAndAfters(s, c, instance);
            s = this.wrapMethodRules(s, c, instance);
            s = RandomizedRunner.withCloseContextResources(s, LifecycleScope.TEST);
            s = threadLeakControl.forTest(s, c);
            s.evaluate();
        }
        catch (Throwable e) {
            e = RandomizedRunner.augmentStackTrace(e, new Randomness[0]);
            if (this.isAssumptionViolated(e)) {
                notifier.fireTestAssumptionFailed(new Failure(c.description, e));
            } else {
                this.fireTestFailure(notifier, c.description, e);
            }
        }
        finally {
            notifier.fireTestFinished(c.description);
        }
    }

    private Statement wrapBeforeAndAfters(Statement s, TestCandidate c, final Object instance) {
        List<Method> afters;
        final List<Method> befores = this.getShuffledMethods(Before.class);
        if (!befores.isEmpty()) {
            final Statement afterBefores = s;
            s = new Statement(){

                public void evaluate() throws Throwable {
                    for (Method m : befores) {
                        RandomizedRunner.this.invoke(m, instance, new Object[0]);
                    }
                    afterBefores.evaluate();
                }
            };
        }
        if (!(afters = this.getShuffledMethods(After.class)).isEmpty()) {
            final Statement beforeAfters = s;
            s = new Statement(){

                public void evaluate() throws Throwable {
                    ArrayList<Throwable> cumulative = new ArrayList<Throwable>();
                    try {
                        beforeAfters.evaluate();
                    }
                    catch (Throwable t) {
                        cumulative.add(t);
                    }
                    for (Method m : afters) {
                        try {
                            RandomizedRunner.this.invoke(m, instance, new Object[0]);
                        }
                        catch (Throwable t) {
                            cumulative.add(t);
                        }
                    }
                    if (cumulative.size() == 1) {
                        throw (Throwable)cumulative.get(0);
                    }
                    if (cumulative.size() > 1) {
                        throw new MultipleFailureException(cumulative);
                    }
                }
            };
        }
        return s;
    }

    private Statement wrapExpectedExceptions(final Statement s, TestCandidate c) {
        Test ann = c.method.getAnnotation(Test.class);
        if (ann == null) {
            return s;
        }
        final Class expectedClass = ann.expected();
        if (expectedClass.getName().equals("org.junit.Test$None")) {
            return s;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    if (!expectedClass.isInstance(t)) {
                        throw t;
                    }
                    return;
                }
                Assert.fail((String)("Expected an exception but the test passed: " + expectedClass.getName()));
            }
        };
    }

    private Statement wrapMethodRules(Statement s, TestCandidate c, Object instance) {
        FrameworkMethod fm = new FrameworkMethod(c.method);
        List<MethodRule> methodRules = this.getAnnotatedFieldValues(instance, Rule.class, MethodRule.class);
        for (MethodRule rule : methodRules) {
            s = rule.apply(s, fm, instance);
        }
        List<TestRule> testRules = this.getAnnotatedFieldValues(instance, Rule.class, TestRule.class);
        for (TestRule rule : testRules) {
            s = rule.apply(s, c.description);
        }
        return s;
    }

    private <T> List<T> getAnnotatedFieldValues(Object test, Class<? extends Annotation> annotationClass, Class<T> valueClass) {
        TestClass info = AccessController.doPrivileged(new PrivilegedAction<TestClass>(){

            @Override
            public TestClass run() {
                return new TestClass(RandomizedRunner.this.suiteClass);
            }
        });
        ArrayList<T> results = new ArrayList<T>();
        ArrayList annotatedFields = new ArrayList(info.getAnnotatedFields(annotationClass));
        HashMap byClass = new HashMap();
        for (FrameworkField field : annotatedFields) {
            Class<?> clz = field.getField().getDeclaringClass();
            if (!byClass.containsKey(clz)) {
                byClass.put(clz, new ArrayList());
            }
            ((List)byClass.get(clz)).add(field);
        }
        for (List fields : byClass.values()) {
            Collections.sort(fields, new Comparator<FrameworkField>(){

                @Override
                public int compare(FrameworkField o1, FrameworkField o2) {
                    return o1.getField().getName().compareTo(o2.getField().getName());
                }
            });
            Collections.shuffle(fields, new Random(this.runnerRandomness.getSeed()));
        }
        annotatedFields.clear();
        for (Class<?> clz = this.suiteClass; clz != null; clz = clz.getSuperclass()) {
            List clzFields = (List)byClass.get(clz);
            if (clzFields == null) continue;
            annotatedFields.addAll(clzFields);
        }
        for (FrameworkField each : annotatedFields) {
            try {
                Object fieldValue = each.get(test);
                if (!valueClass.isInstance(fieldValue)) continue;
                results.add(valueClass.cast(fieldValue));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private RandomizedContext createContext(ThreadGroup tg) {
        return RandomizedContext.create(tg, this.suiteClass, this);
    }

    private void subscribeListeners(RunNotifier notifier) {
        for (Listeners ann : RandomizedRunner.getAnnotationsFromClassHierarchy(this.suiteClass, Listeners.class)) {
            for (Class<? extends RunListener> clazz : ann.value()) {
                try {
                    RunListener listener = clazz.newInstance();
                    this.autoListeners.add(listener);
                    notifier.addListener(listener);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not initialize suite class: " + this.suiteClass.getName() + " because its @Listener is not instantiable: " + clazz.getName(), t);
                }
            }
        }
    }

    private void unsubscribeListeners(RunNotifier notifier) {
        for (RunListener r : this.autoListeners) {
            notifier.removeListener(r);
        }
    }

    private static List<TestCandidate> applyFilters(Class<?> suiteClass, List<TestCandidate> testCandidates, Collection<Filter> testFilters) {
        ArrayList<TestCandidate> filtered;
        if (testFilters.isEmpty()) {
            filtered = new ArrayList<TestCandidate>(testCandidates);
        } else {
            filtered = new ArrayList(testCandidates.size());
            for (TestCandidate candidate : testCandidates) {
                boolean shouldRun = true;
                for (Filter f : testFilters) {
                    if (f.shouldRun(candidate.description) || f.shouldRun(Description.createTestDescription(suiteClass, (String)candidate.method.getName()))) continue;
                    shouldRun = false;
                    break;
                }
                if (!shouldRun) continue;
                filtered.add(candidate);
            }
        }
        return filtered;
    }

    static String emptyToNull(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value.trim();
    }

    private boolean hasIgnoreAnnotation(TestCandidate c) {
        return c.method.getAnnotation(Ignore.class) != null;
    }

    private boolean isTestFiltered(GroupEvaluator ev, TestCandidate c) {
        return ev.getIgnoreReason(c.method, this.suiteClass) != null;
    }

    private List<Method> getShuffledMethods(Class<? extends Annotation> ann) {
        List<Method> methods = this.shuffledMethodsCache.get(ann);
        if (methods != null) {
            return methods;
        }
        methods = new ArrayList<Method>(this.classModel.getAnnotatedLeafMethods(ann).keySet());
        Random rnd = new Random(this.runnerRandomness.getSeed());
        int i = 0;
        int j = 0;
        while (i < methods.size()) {
            Method m = methods.get(i);
            for (j = i + 1; j < methods.size() && m.getDeclaringClass() == methods.get(j).getDeclaringClass(); ++j) {
            }
            if (j - i > 1) {
                Collections.shuffle(methods.subList(i, j), rnd);
            }
            i = j;
        }
        if (ann == Before.class || ann == BeforeClass.class) {
            Collections.reverse(methods);
        }
        methods = Collections.unmodifiableList(methods);
        this.shuffledMethodsCache.put(ann, methods);
        return methods;
    }

    private List<TestCandidate> collectTestCandidates(Description classDescription) {
        TestMethodProvider[] providers;
        TestMethodProviders providersAnnotation = this.suiteClass.getAnnotation(TestMethodProviders.class);
        if (providersAnnotation != null) {
            providers = new TestMethodProvider[providersAnnotation.value().length];
            int i = 0;
            for (Class<? extends TestMethodProvider> clazz : providersAnnotation.value()) {
                try {
                    providers[i++] = (TestMethodProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(TestMethodProviders.class.getSimpleName() + " classes could not be instantiated.", e);
                }
            }
        } else {
            providers = new TestMethodProvider[]{new JUnit4MethodProvider()};
        }
        HashSet<Method> allTestMethods = new HashSet<Method>();
        for (TestMethodProvider provider : providers) {
            Collection<Method> testMethods = provider.getTestMethods(this.suiteClass, this.classModel);
            allTestMethods.addAll(testMethods);
        }
        ArrayList<Method> testMethods = new ArrayList<Method>(allTestMethods);
        Collections.sort(testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.toGenericString().compareTo(m2.toGenericString());
            }
        });
        this.validateTestMethods(testMethods);
        Collections.shuffle(testMethods, new Random(this.runnerRandomness.getSeed()));
        Constructor<?>[] constructors = this.suiteClass.getConstructors();
        if (constructors.length != 1) {
            throw new RuntimeException("There must be exactly one constructor: " + constructors.length);
        }
        Constructor<?> constructor = constructors[0];
        List<TestMethodExecution> testCases = this.collectMethodExecutions(constructor, testMethods);
        TestCaseOrdering methodOrder = this.suiteClass.getAnnotation(TestCaseOrdering.class);
        if (methodOrder != null) {
            try {
                Collections.sort(testCases, methodOrder.value().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not sort test methods.", e);
            }
        }
        HashMap<String, Integer> descriptionRepetitions = new HashMap<String, Integer>();
        ArrayList<TestCandidate> allTests = new ArrayList<TestCandidate>();
        LinkedHashMap<Method, ArrayList<TestCandidate>> sameMethodVariants = new LinkedHashMap<Method, ArrayList<TestCandidate>>();
        for (TestMethodExecution testMethodExecution : testCases) {
            List<TestCandidate> variants = this.collectCandidatesForMethod(descriptionRepetitions, constructor, testMethodExecution);
            allTests.addAll(variants);
            ArrayList<TestCandidate> existing = (ArrayList<TestCandidate>)sameMethodVariants.get(testMethodExecution.method);
            if (existing == null) {
                existing = new ArrayList<TestCandidate>(variants);
                sameMethodVariants.put(testMethodExecution.method, existing);
                continue;
            }
            existing.addAll(variants);
        }
        for (Map.Entry entry : sameMethodVariants.entrySet()) {
            List candidates = (List)entry.getValue();
            if (candidates.size() > 1) {
                Description methodParent = Description.createSuiteDescription((String)((Method)entry.getKey()).getName(), (Annotation[])new Annotation[0]);
                this.suiteDescription.addChild(methodParent);
                for (TestCandidate candidate : candidates) {
                    methodParent.addChild(candidate.description);
                }
                continue;
            }
            this.suiteDescription.addChild(((TestCandidate)candidates.iterator().next()).description);
        }
        return allTests;
    }

    private List<TestCandidate> collectCandidatesForMethod(Map<String, Integer> descriptionRepetitions, Constructor<?> constructor, TestMethodExecution testCase) {
        Method method = testCase.method;
        Object[] params = testCase.params;
        boolean fixedSeed = this.isConstantSeedForAllIterations(method);
        int methodIterations = this.determineMethodIterationCount(method);
        long[] seeds = this.determineMethodSeeds(method);
        ArrayList<TestCandidate> candidates = new ArrayList<TestCandidate>();
        String argFormattingTemplate = testCase.argFormattingTemplate;
        if (methodIterations > 1 || seeds.length > 1 || this.appendSeedParameter) {
            int seedParamIndex = params.length + 1;
            argFormattingTemplate = argFormattingTemplate + " seed=%" + seedParamIndex + "$s";
        }
        for (long testSeed : seeds) {
            for (int i = 0; i < methodIterations; ++i) {
                long thisSeed = fixedSeed ? testSeed : testSeed ^ MurmurHash3.hash((long)i);
                Object[] args = Arrays.copyOf(testCase.params, testCase.params.length + 1, Object[].class);
                args[args.length - 1] = SeedUtils.formatSeedChain(this.runnerRandomness, new Randomness(thisSeed, this.randomSupplier, new SeedDecorator[0]));
                String formattedArguments = String.format(Locale.ROOT, argFormattingTemplate, args);
                String key = method.getName() + "::" + formattedArguments;
                int cnt = 1 + RandomizedRunner.zeroForNull(descriptionRepetitions.get(key));
                descriptionRepetitions.put(key, cnt);
                if (cnt > 1) {
                    formattedArguments = formattedArguments + " #" + cnt;
                }
                if (!formattedArguments.trim().isEmpty()) {
                    formattedArguments = this.containerRunner == RunnerContainer.IDEA ? " [" + formattedArguments.trim() + "]" : " {" + formattedArguments.trim() + "}";
                }
                Description description = Description.createSuiteDescription((String)String.format(Locale.ROOT, "%s%s(%s)", method.getName(), formattedArguments, this.suiteClass.getName()), (Annotation[])method.getAnnotations());
                candidates.add(new TestCandidate(method, thisSeed, description, testCase.instanceProvider));
            }
        }
        return candidates;
    }

    private static int zeroForNull(Integer v) {
        return v == null ? 0 : v;
    }

    public List<TestMethodExecution> collectMethodExecutions(Constructor<?> constructor, List<Method> testMethods) {
        ArrayList<TestMethodExecution> testCases = new ArrayList<TestMethodExecution>();
        String argFormattingTemplate = RandomizedRunner.createDefaultArgumentFormatting(constructor);
        Map<Method, ClassModel.MethodModel> factoryMethods = this.classModel.getAnnotatedLeafMethods(ParametersFactory.class);
        if (factoryMethods.isEmpty()) {
            Object[] noArgs = new Object[]{};
            InstanceProvider instanceProvider = this.getInstanceProvider(constructor, noArgs);
            for (Method testMethod : testMethods) {
                testCases.add(new TestMethodExecution(testMethod, argFormattingTemplate, noArgs, instanceProvider));
            }
        } else {
            for (Method factoryMethod : factoryMethods.keySet()) {
                Validation.checkThat(factoryMethod).isStatic().isPublic();
                if (!Iterable.class.isAssignableFrom(factoryMethod.getReturnType())) {
                    throw new RuntimeException("@" + ParametersFactory.class.getSimpleName() + " annotated methods must be public, static and returning Iterable<Object[]>:" + factoryMethod);
                }
                ParametersFactory pfAnnotation = factoryMethod.getAnnotation(ParametersFactory.class);
                if (!pfAnnotation.argumentFormatting().equals("default")) {
                    argFormattingTemplate = pfAnnotation.argumentFormatting();
                }
                ArrayList<Object[]> args = new ArrayList<Object[]>();
                try {
                    Iterable factoryArguments = (Iterable)Iterable.class.cast(factoryMethod.invoke(null, new Object[0]));
                    for (Object o : factoryArguments) {
                        if (!(o instanceof Object[])) {
                            throw new RuntimeException("Expected Object[] for each set of constructor arguments: " + o);
                        }
                        args.add((Object[])o);
                    }
                }
                catch (InvocationTargetException e) {
                    if (this.isAssumptionViolated(e.getCause())) {
                        return Collections.emptyList();
                    }
                    Rethrow.rethrow(e.getCause());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error collecting parameters from: " + factoryMethod, t);
                }
                if (pfAnnotation.shuffle()) {
                    Collections.shuffle(args, new Random(this.runnerRandomness.getSeed()));
                }
                for (Object[] constructorArgs : args) {
                    InstanceProvider instanceProvider = this.getInstanceProvider(constructor, constructorArgs);
                    for (Method testMethod : testMethods) {
                        testCases.add(new TestMethodExecution(testMethod, argFormattingTemplate, constructorArgs, instanceProvider));
                    }
                }
            }
        }
        return testCases;
    }

    private boolean isAssumptionViolated(Throwable cause) {
        return cause instanceof AssumptionViolatedException || cause instanceof org.junit.internal.AssumptionViolatedException;
    }

    private InstanceProvider getInstanceProvider(Constructor<?> constructor, Object[] args) {
        TestCaseInstanceProvider.Type type = TestCaseInstanceProvider.Type.INSTANCE_PER_TEST_METHOD;
        TestCaseInstanceProvider providerAnn = this.suiteClass.getAnnotation(TestCaseInstanceProvider.class);
        if (providerAnn != null) {
            type = providerAnn.value();
        }
        switch (type) {
            case INSTANCE_PER_CONSTRUCTOR_ARGS: {
                return new SameInstanceProvider(new NewInstanceProvider(constructor, args));
            }
            case INSTANCE_PER_TEST_METHOD: {
                return new NewInstanceProvider(constructor, args);
            }
        }
        throw new RuntimeException();
    }

    private static String createDefaultArgumentFormatting(Constructor<?> constructor) {
        StringBuilder b = new StringBuilder();
        int argCount = constructor.getParameterTypes().length;
        Annotation[][] anns = constructor.getParameterAnnotations();
        for (int i = 0; i < argCount; ++i) {
            String argName = null;
            for (Annotation ann : anns[i]) {
                if (ann == null || !ann.annotationType().equals(Name.class)) continue;
                argName = ((Name)ann).value();
                break;
            }
            if (argName == null) {
                argName = "p" + i;
            }
            b.append(i > 0 ? " " : "").append(argName).append("=%s");
        }
        return b.toString();
    }

    private boolean isConstantSeedForAllIterations(Method method) {
        if (this.testCaseRandomnessOverride != null) {
            return true;
        }
        Repeat repeat = method.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.useConstantSeed();
        }
        repeat = this.suiteClass.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.useConstantSeed();
        }
        return false;
    }

    private int determineMethodIterationCount(Method method) {
        if (this.iterationsOverride != null) {
            return this.iterationsOverride;
        }
        Repeat repeat = method.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.iterations();
        }
        repeat = this.suiteClass.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.iterations();
        }
        return 1;
    }

    private long[] determineMethodSeeds(Method method) {
        long[] seedChain;
        Seeds seedsValue;
        if (this.testCaseRandomnessOverride != null) {
            return new long[]{this.testCaseRandomnessOverride.getSeed()};
        }
        long randomSeed = this.runnerRandomness.getSeed() ^ MurmurHash3.hash((long)method.getName().hashCode());
        HashSet<Long> seeds = new HashSet<Long>();
        Seed seed = method.getAnnotation(Seed.class);
        if (seed != null) {
            for (long s : this.seedFromAnnot(method, randomSeed)) {
                seeds.add(s);
            }
        }
        if ((seedsValue = this.classModel.getAnnotation(method, Seeds.class, true)) != null) {
            for (Seed seed2 : seedsValue.value()) {
                if (seed2.value().equals("random")) {
                    seeds.add(randomSeed);
                    continue;
                }
                for (long s2 : SeedUtils.parseSeedChain(seed2.value())) {
                    seeds.add(s2);
                }
            }
        }
        if (seeds.isEmpty() && (seed = this.suiteClass.getAnnotation(Seed.class)) != null && !seed.value().equals("random") && (seedChain = SeedUtils.parseSeedChain(this.suiteClass.getAnnotation(Seed.class).value())).length > 1) {
            seeds.add(seedChain[1]);
        }
        if (seeds.isEmpty()) {
            seeds.add(randomSeed);
        }
        long[] result = new long[seeds.size()];
        int i = 0;
        for (Long l : seeds) {
            result[i++] = l;
        }
        return result;
    }

    void invoke(final Method m, Object instance, Object ... args) throws Throwable {
        if (!Modifier.isPublic(m.getModifiers())) {
            try {
                if (!m.isAccessible()) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            m.setAccessible(true);
                            return null;
                        }
                    });
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("There is a non-public method that needs to be called. This requires ReflectPermission('suppressAccessChecks'). Don't run with the security manager or  add this permission to the runner. Offending method: " + m.toGenericString());
            }
        }
        try {
            m.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void validateTestMethods(List<Method> testMethods) {
        HashSet parents = new HashSet();
        for (Class<?> c = this.suiteClass; c != null; c = c.getSuperclass()) {
            parents.add(c);
        }
        for (Method method : testMethods) {
            if (!parents.contains(method.getDeclaringClass())) {
                throw new IllegalArgumentException("Test method does not belong to test suite class hierarchy: " + method.getDeclaringClass() + "#" + method.getName());
            }
            Validation.checkThat(method).describedAs("Test method " + this.suiteClass.getName() + "#" + method.getName()).isPublic().isNotStatic().hasArgsCount(0);
            Test testAnn = this.classModel.getAnnotation(method, Test.class, true);
            if (testAnn != null && testAnn.timeout() > 0L && this.classModel.isAnnotationPresent(method, Timeout.class, true)) {
                throw new IllegalArgumentException("Conflicting @Test(timeout=...) and @Timeout annotations in: " + this.suiteClass.getName() + "#" + method.getName());
            }
            Seed seed = this.classModel.getAnnotation(method, Seed.class, true);
            if (seed == null) continue;
            try {
                long[] chain;
                String seedChain = seed.value();
                if (seedChain.equals("random") || (chain = SeedUtils.parseSeedChain(seedChain)).length <= 1) continue;
                throw new IllegalArgumentException("@Seed on methods must contain one seed only (no runner seed).");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("@Seed annotation invalid on method " + method.getName() + ", in class " + this.suiteClass.getName() + ": " + e.getMessage());
            }
        }
    }

    private void validateTarget() {
        Validation.checkThat(this.suiteClass).describedAs("Suite class " + this.suiteClass.getName()).isPublic().isConcreteClass();
        Constructor<?>[] constructors = this.suiteClass.getConstructors();
        if (constructors.length != 1 || !Modifier.isPublic(constructors[0].getModifiers())) {
            throw new RuntimeException("A test class is expected to have one public constructor  (parameterless or with types matching static @" + ParametersFactory.class + "-annotated method's output): " + this.suiteClass.getName());
        }
        if (constructors[0].getParameterTypes().length > 0) {
            Set<Method> factories = this.classModel.getAnnotatedLeafMethods(ParametersFactory.class).keySet();
            if (factories.isEmpty()) {
                throw new RuntimeException("A test class with a parameterized constructor is expected  to have a static @" + ParametersFactory.class + "-annotated method: " + this.suiteClass.getName());
            }
            for (Method m : factories) {
                Validation.checkThat(m).describedAs("@ParametersFactory method " + this.suiteClass.getName() + "#" + m.getName()).isStatic().isPublic().hasArgsCount(0).hasReturnType(Iterable.class);
            }
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(BeforeClass.class).keySet()) {
            Validation.checkThat(method).describedAs("@BeforeClass method " + this.suiteClass.getName() + "#" + method.getName()).isStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(AfterClass.class).keySet()) {
            Validation.checkThat(method).describedAs("@AfterClass method " + this.suiteClass.getName() + "#" + method.getName()).isStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(Before.class).keySet()) {
            Validation.checkThat(method).describedAs("@Before method " + this.suiteClass.getName() + "#" + method.getName()).isNotStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(After.class).keySet()) {
            Validation.checkThat(method).describedAs("@After method " + this.suiteClass.getName() + "#" + method.getName()).isNotStatic().hasArgsCount(0);
        }
    }

    static <T extends Throwable> T augmentStackTrace(T e, Randomness ... seeds) {
        if (seeds.length == 0) {
            seeds = RandomizedContext.current().getRandomnesses();
        }
        String seedChain = SeedUtils.formatSeedChain(seeds);
        String existingSeed = RandomizedRunner.seedFromThrowable(e);
        if (existingSeed != null && existingSeed.equals(seedChain)) {
            return e;
        }
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
        stack.add(0, new StackTraceElement("__randomizedtesting.SeedInfo", "seed", seedChain, 0));
        e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
        return e;
    }

    private static <T extends Annotation> List<T> getAnnotationsFromClassHierarchy(Class<?> clazz, Class<T> annotation) {
        ArrayList<T> anns = new ArrayList<T>();
        IdentityHashMap<T, T> inherited = new IdentityHashMap<T, T>();
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            T ann;
            if (!c.isAnnotationPresent(annotation) || (ann = c.getAnnotation(annotation)).annotationType().isAnnotationPresent(Inherited.class) && inherited.containsKey(ann)) continue;
            anns.add(ann);
            inherited.put(ann, ann);
        }
        Collections.reverse(anns);
        return anns;
    }

    private long[] seedFromAnnot(AnnotatedElement element, long randomSeed) {
        Seed seed = element.getAnnotation(Seed.class);
        String seedChain = seed.value();
        if (seedChain.equals("random")) {
            return new long[]{randomSeed};
        }
        return SeedUtils.parseSeedChain(seedChain);
    }

    public TraceFormatting getTraceFormatting() {
        return this.traces;
    }

    public static String seedFromThrowable(Throwable t) {
        StringBuilder b = new StringBuilder();
        while (t != null) {
            for (StackTraceElement s : t.getStackTrace()) {
                if (!s.getClassName().startsWith(AUGMENTED_SEED_PACKAGE)) continue;
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(s.getFileName());
            }
            t = t.getCause();
        }
        if (b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    public static String methodName(Description description) {
        return description.getMethodName().replaceAll("\\s?\\{.+\\}", "");
    }

    public static boolean hasZombieThreads() {
        return zombieMarker.get();
    }

    private static class NewInstanceProvider
    implements InstanceProvider {
        private final Constructor<?> constructor;
        private final Object[] args;

        public NewInstanceProvider(Constructor<?> constructor, Object[] args) {
            this.constructor = constructor;
            this.args = args;
        }

        @Override
        public Object newInstance() throws Throwable {
            try {
                return this.constructor.newInstance(this.args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Constructor arguments do not match provider parameters?", e);
            }
        }
    }

    private static class SameInstanceProvider
    implements InstanceProvider {
        private final InstanceProvider delegate;
        private volatile Object instance;

        public SameInstanceProvider(InstanceProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object newInstance() throws Throwable {
            if (this.instance == null) {
                this.instance = this.delegate.newInstance();
            }
            return this.instance;
        }
    }

    private static class TestMethodExecution
    implements TestMethodAndParams {
        final Object[] params;
        final List<Object> paramsWrapper;
        final Method method;
        final String argFormattingTemplate;
        final InstanceProvider instanceProvider;

        public TestMethodExecution(Method m, String argFormattingTemplate, Object[] params, InstanceProvider instanceProvider) {
            this.method = m;
            this.params = params;
            this.paramsWrapper = Collections.unmodifiableList(Arrays.asList(params));
            this.argFormattingTemplate = argFormattingTemplate;
            this.instanceProvider = instanceProvider;
        }

        @Override
        public Method getTestMethod() {
            return this.method;
        }

        @Override
        public List<Object> getInstanceArguments() {
            return this.paramsWrapper;
        }
    }

    static class QueueUncaughtExceptionsHandler
    implements Thread.UncaughtExceptionHandler {
        private final ArrayList<UncaughtException> uncaughtExceptions = new ArrayList();
        private boolean reporting = true;

        QueueUncaughtExceptionsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                if (!this.reporting) {
                    return;
                }
                this.uncaughtExceptions.add(new UncaughtException(t, e));
            }
            Logger.getLogger(RunnerThreadGroup.class.getSimpleName()).log(Level.WARNING, "Uncaught exception in thread: " + t, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopReporting() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                this.reporting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeReporting() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                this.reporting = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<UncaughtException> getUncaughtAndClear() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                ArrayList<UncaughtException> copy = new ArrayList<UncaughtException>(this.uncaughtExceptions);
                this.uncaughtExceptions.clear();
                return copy;
            }
        }
    }

    static class UncaughtException {
        final Thread thread;
        final String threadName;
        final Throwable error;

        UncaughtException(Thread t, Throwable error) {
            this.threadName = Threads.threadName(t);
            this.thread = t;
            this.error = error;
        }
    }

    class TestCandidate {
        public final long seed;
        public final Description description;
        public final Method method;
        public final InstanceProvider instanceProvider;

        public TestCandidate(Method method, long seed, Description description, InstanceProvider instanceProvider) {
            this.seed = seed;
            this.description = description;
            this.method = method;
            this.instanceProvider = instanceProvider;
        }

        public Class<?> getTestClass() {
            return RandomizedRunner.this.suiteClass;
        }
    }
}

